<?php
include 'assets/config/connect.php';
session_start();

if (!isset($_GET['member_id']) || !is_numeric($_GET['member_id'])) {
    header('Location: members_list.php');
    exit();
}

$member_id = $_GET['member_id'];

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $height = $_POST['height'];
    $weight = $_POST['weight'];
    $chest = $_POST['chest'];
    $biceps = $_POST['biceps'];
    $waist = $_POST['waist'];
    $measured_on = $_POST['measured_on'];
    
    $sql = "INSERT INTO measurements (member_id, height, weight, chest, biceps, waist, measured_on) 
            VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("iddddds", $member_id, $height, $weight, $chest, $biceps, $waist, $measured_on);
    
    if ($stmt->execute()) {
        $_SESSION['success'] = "Measurement added successfully!";
        header("Location: member_profile.php?id=$member_id");
        exit();
    } else {
        $_SESSION['error'] = "Error adding measurement: " . $conn->error;
    }
}

// Fetch member details for header
$sql = "SELECT name FROM members WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $member_id);
$stmt->execute();
$result = $stmt->get_result();
$member = $result->fetch_assoc();
?>

<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Add Body Measurement</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Bootstrap Css -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>

<body data-sidebar="dark">
    <?php include 'assets/config/header.php' ?>
    <?php include 'assets/config/sidebar.php' ?>

    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-flex align-items-center justify-content-between">
                            <h4 class="mb-0">Add Body Measurement for <?= htmlspecialchars($member['name']) ?></h4>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-6">
                        <div class="card">
                            <div class="card-body">
                                <?php if (isset($_SESSION['error'])): ?>
                                    <div class="alert alert-danger"><?= $_SESSION['error'] ?></div>
                                    <?php unset($_SESSION['error']); ?>
                                <?php endif; ?>

                                <form method="POST">
                                    <div class="mb-3">
                                        <label class="form-label">Height (cm)</label>
                                        <input type="number" step="0.1" class="form-control" name="height" required>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Weight (kg)</label>
                                        <input type="number" step="0.1" class="form-control" name="weight" required>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Chest (cm)</label>
                                        <input type="number" step="0.1" class="form-control" name="chest" required>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Biceps (cm)</label>
                                        <input type="number" step="0.1" class="form-control" name="biceps" required>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Waist (cm)</label>
                                        <input type="number" step="0.1" class="form-control" name="waist" required>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Measurement Date</label>
                                        <input type="date" class="form-control" name="measured_on" value="<?= date('Y-m-d') ?>" required>
                                    </div>
                                    
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save me-2"></i> Save Measurement
                                        </button>
                                        <a href="member_profile.php?id=<?= $member_id ?>" class="btn btn-secondary">
                                            <i class="fas fa-times me-2"></i> Cancel
                                        </a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-6">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Measurement Guidelines</h5>
                                <ul>
                                    <li>Measure height without shoes</li>
                                    <li>Measure weight in the morning before eating</li>
                                    <li>Chest measurement should be taken at nipple level</li>
                                    <li>Biceps measurement should be taken at the largest point when flexed</li>
                                    <li>Waist measurement should be taken at the narrowest point</li>
                                    <li>Always measure at the same time of day for consistency</li>
                                </ul>
                                <div class="text-center">
                                    <img src="assets/images/measurement-guide.jpg" alt="Measurement Guide" class="img-fluid rounded">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/libs/metismenu/metisMenu.min.js"></script>
    <script src="assets/libs/simplebar/simplebar.min.js"></script>
    <script src="assets/libs/node-waves/waves.min.js"></script>
    <script src="assets/js/app.js"></script>
</body>
</html>