<?php
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in and get role
$isLoggedIn = isset($_SESSION['role']);
$role = $_SESSION['role'] ?? '';
$userEmail = $_SESSION['email'] ?? '';
$isSuperAdmin = ($userEmail === 'admin@gmail.com');
?>

<header id="page-topbar">
    <div class="navbar-header">
        <div class="d-flex">
            <!-- LOGO -->
            <div class="navbar-brand-box">
                <a href="index" class="logo logo-dark">
                    <span class="logo-sm">
                        <img src="assets/images/logo-sm.png" alt="" height="35">
                    </span>
                    <span class="logo-lg">
                        <img src="assets/images/logo-dark.png" alt="" height="45">
                    </span>
                </a>

                <a href="index" class="logo logo-light">
                    <span class="logo-sm">
                        <img src="assets/images/logo-sm.png" alt="" height="35">
                    </span>
                    <span class="logo-lg">
                        <img src="assets/images/logo-light.png" alt="" height="45">
                    </span>
                </a>
            </div>

            <button type="button" class="btn btn-sm px-3 font-size-24 header-item waves-effect vertical-menu-btn">
                <i class="mdi mdi-menu"></i>
            </button>

            <!-- Display current role badge -->
            <?php if ($isLoggedIn): ?>
                <div class="d-flex align-items-center ms-2">
                    <span class="badge bg-<?= ($role === 'admin') ? 'danger' : 'primary' ?>">
                        <?= ucfirst($role) ?>
                        <?php if ($isSuperAdmin): ?>
                            <span class="ms-1">(Super Admin)</span>
                        <?php endif; ?>
                    </span>
                </div>
            <?php endif; ?>
        </div>

        <div class="d-flex">
            <?php if ($isLoggedIn): ?>
                <!-- Notification dropdown - different for admin/member -->
               

                <!-- User profile dropdown -->
                <div class="dropdown d-inline-block">
                    <button type="button" class="btn header-item waves-effect" id="page-header-user-dropdown"
                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <img class="rounded-circle header-profile-user" src="assets/images/users/user-4.jpg"
                            alt="Header Avatar">
                        <span class="d-none d-xl-inline-block ms-1">
                            <?= $role === 'admin' ? 'Admin' : 'Member' ?>
                        </span>
                        <i class="mdi mdi-chevron-down d-none d-xl-inline-block"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-end">
                        <!-- Common items for all roles -->
                        
                        
                        <?php if ($role === 'admin'): ?>
                            <!-- Admin-specific items -->
                            
                        <?php else: ?>
                            <!-- Member-specific items -->
                            <a class="dropdown-item" href="my-membership.php">
                                <i class="mdi mdi-card-account-details font-size-17 text-muted align-middle me-1"></i>
                                My Membership
                            </a>
                        <?php endif; ?>
                        
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item text-danger" href="logout.php">
                            <i class="mdi mdi-power font-size-17 text-muted align-middle me-1 text-danger"></i>
                            Logout
                        </a>
                    </div>
                </div>
            <?php else: ?>
                <!-- Show login button if not logged in -->
                <div class="d-inline-block">
                    <a href="login.php" class="btn btn-primary">Login</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</header>