<?php
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit();
}

$role = $_SESSION['role'];
$isSuperAdmin = ($_SESSION['email'] ?? '') === 'admin@gmail.com';
?>

<div class="vertical-menu">
    <div data-simplebar class="h-100">
        <div id="sidebar-menu">
            <ul class="metismenu list-unstyled" id="side-menu">
                <li class="menu-title">Main</li>

                <!-- Dashboard - Visible to all roles -->
                <li>
                    <a href="index" class="waves-effect">
                        <i class="mdi mdi-view-dashboard"></i>
                        <span>Dashboard</span>
                    </a>
                </li>

                <?php if ($role === 'admin'): ?>
                    <!-- ADMIN ONLY MENU ITEMS -->
                    <li class="menu-title">Administration</li>

                    <!-- Member Management -->
                    <li>
                        <a href="javascript: void(0);" class="waves-effect">
                            <i class="mdi mdi-clipboard-outline"></i>
                            <span>Member Management</span>
                        </a>
                        <ul class="sub-menu" aria-expanded="false">
                            <li><a href="register-member">Register Member</a></li>
                            <li><a href="memberlist">Members List</a></li>
                        </ul>
                    </li>
                    <li>
                        <a href="javascript: void(0);" class="waves-effect">
                            <i class="mdi mdi-clipboard-outline"></i>
                            <span>Product Management</span>
                        </a>
                        <ul class="sub-menu" aria-expanded="false">
                            <li><a href="add-product">Add Product</a></li>
                            <li><a href="product-list">Product List</a></li>
                        </ul>
                    </li>

                   

                <?php elseif ($role === 'member'): ?>
                    <!-- MEMBER (USER) ONLY MENU ITEMS -->
                    <li class="menu-title">My Account</li>

                    <!-- Profile -->
                    <li>
                        <a href="my-profile.php" class="waves-effect">
                            <i class="mdi mdi-account-circle"></i>
                            <span>My Profile</span>
                        </a>
                    </li>

                    <!-- Membership -->
                    <li>
                        <a href="my-membership.php" class="waves-effect">
                            <i class="mdi mdi-card-account-details"></i>
                            <span>My Membership</span>
                        </a>
                    </li>

                    <!-- Order History -->
                    
                <?php endif; ?>

              
               

                <!-- Logout -->
                <li>
                    <a href="logout" class="waves-effect">
                        <i class="mdi mdi-logout"></i>
                        <span>Logout</span>
                    </a>
                </li>
            </ul>
        </div>
    </div>

    <style>
        #sidebar-menu {
            z-index: 9999 !important;
        }
    </style>
</div>