<?php
session_start();
include 'assets/config/connect.php';

// Check if product ID is provided
if (isset($_GET['id'])) {
    $product_id = (int)$_GET['id'];
    
    // Start transaction
    mysqli_begin_transaction($conn);
    
    try {
        // Get all image paths for this product
        $images_sql = "SELECT image_path FROM product_images WHERE product_id = $product_id";
        $images_result = mysqli_query($conn, $images_sql);
        
        // Delete product images from server
        while ($image = mysqli_fetch_assoc($images_result)) {
            if (file_exists($image['image_path'])) {
                unlink($image['image_path']);
            }
        }
        
        // Delete product images from database
        $delete_images_sql = "DELETE FROM product_images WHERE product_id = $product_id";
        mysqli_query($conn, $delete_images_sql);
        
        // Delete product from database
        $delete_product_sql = "DELETE FROM products WHERE id = $product_id";
        $result = mysqli_query($conn, $delete_product_sql);
        
        if ($result) {
            // Commit transaction
            mysqli_commit($conn);
            $_SESSION['success'] = "Product deleted successfully!";
        } else {
            throw new Exception("Error deleting product: " . mysqli_error($conn));
        }
    } catch (Exception $e) {
        // Rollback transaction on error
        mysqli_rollback($conn);
        $_SESSION['error'] = $e->getMessage();
    }
} else {
    $_SESSION['error'] = "No product ID specified!";
}

// Redirect back to product list
header("Location: product-list.php");
exit();
?>