<?php
session_start();
include 'assets/config/connect.php';

$error = ''; // Initialize error variable
$id = $_GET['id'];
$query = "SELECT * FROM members WHERE id = $id";
$result = mysqli_query($conn, $query);
$row = mysqli_fetch_assoc($result);


$measureQuery = "SELECT * FROM measurements WHERE member_id = $id ORDER BY measured_on DESC LIMIT 1";
$measureResult = mysqli_query($conn, $measureQuery);
$measure = mysqli_fetch_assoc($measureResult);

?>

<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Gym - Edit Member</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/logo-sm.png">

    <!-- Bootstrap Css -->
    <link href="assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />
    <style>
        .error-message {
            color: #dc3545;
            font-size: 0.875em;
            margin-top: 0.25rem;
        }

        .is-invalid {
            border-color: #dc3545 !important;
        }
    </style>
</head>

<body data-sidebar="dark">
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'assets/config/header.php' ?>
        <?php include 'assets/config/sidebar.php' ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="page-title-box">
                                <h4> Members</h4>
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item active">Edit Member</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="card-title">Edit Member </h4>
                                    <p class="card-title-desc">Fill All Details Carefully
                                        <span class="badge bg-primary">Gym</span>
                                    </p>
                                    <form method="POST" action="update_member.php" enctype="multipart/form-data"
                                        id="editForm">
                                        <input type="hidden" name="id" value="<?= $row['id'] ?>">

                                        <div class="row">
                                            <!-- Name -->
                                            <div class="col-md-4 mb-3">
                                                <label>Name</label>
                                                <input type="text" name="name"
                                                    value="<?= htmlspecialchars($row['name']) ?>" class="form-control"
                                                    required>
                                            </div>

                                            <!-- Phone -->
                                            <div class="col-md-4 mb-3">
                                                <label>Phone</label>
                                                <input type="text" name="phone"
                                                    value="<?= htmlspecialchars($row['phone']) ?>" class="form-control"
                                                    required>
                                            </div>

                                            <!-- Email -->
                                            <div class="col-md-4 mb-3">
                                                <label>Email</label>
                                                <input type="email" name="email"
                                                    value="<?= htmlspecialchars($row['email']) ?>" class="form-control"
                                                    required>
                                            </div>

                                            <!-- Address -->
                                            <div class="col-md-6 mb-3">
                                                <label>Address</label>
                                                <textarea name="address" class="form-control"
                                                    required><?= htmlspecialchars($row['address']) ?></textarea>
                                            </div>

                                            <!-- Start Date -->
                                            <div class="col-md-3 mb-3">
                                                <label>Start Date</label>
                                                <input type="date" id="start_date" name="start_date"
                                                    value="<?= $row['start_date'] ?>" class="form-control" required>
                                            </div>

                                            <!-- Membership Type -->
                                            <div class="col-md-3 mb-3">
                                                <label>Membership Plan</label>
                                                <select name="membership_type" id="membership_type" class="form-control"
                                                    required onchange="updatePriceAndEndDate()">
                                                    <option value="">Select</option>
                                                    <option value="Monthly" <?= $row['membership_type'] == 'Monthly' ? 'selected' : '' ?>>Monthly</option>
                                                    <option value="Quarterly" <?= $row['membership_type'] == 'Quarterly' ? 'selected' : '' ?>>Quarterly</option>
                                                    <option value="Half-Yearly"
                                                        <?= $row['membership_type'] == 'Half-Yearly' ? 'selected' : '' ?>>
                                                        Half-Yearly</option>
                                                    <option value="Yearly" <?= $row['membership_type'] == 'Yearly' ? 'selected' : '' ?>>Yearly</option>
                                                </select>
                                            </div>

                                            <!-- Auto Price -->
                                            <div class="col-md-3 mb-3">
                                                <label>Price</label>
                                                <input type="text" id="price" name="amount"
                                                    value="<?= $row['amount'] ?>" class="form-control" readonly>
                                            </div>

                                            <!-- Auto End Date -->
                                            <div class="col-md-3 mb-3">
                                                <label>End Date</label>
                                                <input type="date" id="end_date" name="end_date"
                                                    value="<?= $row['end_date'] ?>" class="form-control" readonly>
                                            </div>

                                            <!-- Body Measurements -->
                                            <div class="col-md-2 mb-3">
                                                <label>Height (cm)</label>
                                                <input type="number" name="height" class="form-control"
                                                    value="<?= $measure['height'] ?? '' ?>">
                                            </div>
                                            <div class="col-md-2 mb-3">
                                                <label>Weight (kg)</label>
                                                <input type="number" name="weight" class="form-control"
                                                    value="<?= $measure['weight'] ?? '' ?>">
                                            </div>
                                            <div class="col-md-2 mb-3">
                                                <label>Chest (cm)</label>
                                                <input type="number" name="chest" class="form-control"
                                                    value="<?= $measure['chest'] ?? '' ?>">
                                            </div>
                                            <div class="col-md-2 mb-3">
                                                <label>Biceps (cm)</label>
                                                <input type="number" name="biceps" class="form-control"
                                                    value="<?= $measure['biceps'] ?? '' ?>">
                                            </div>
                                            <div class="col-md-2 mb-3">
                                                <label>Waist (cm)</label>
                                                <input type="number" name="waist" class="form-control"
                                                    value="<?= $measure['waist'] ?? '' ?>">
                                            </div>

                                            <!-- Update Button -->
                                            <div class="col-md-12 text-center">
                                                <button type="submit" class="btn btn-success mt-3">Update
                                                    Member</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>



                    <!-- comming soon -->










                </div> <!-- container-fluid -->
            </div>
            <!-- End Page-content -->
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <!-- JAVASCRIPT -->
    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/libs/metismenu/metisMenu.min.js"></script>
    <script src="assets/libs/simplebar/simplebar.min.js"></script>
    <script src="assets/libs/node-waves/waves.min.js"></script>
    <script src="assets/libs/jquery-sparkline/jquery.sparkline.min.js"></script>
    <script src="assets/js/app.js"></script>

    <script>
        function updatePriceAndEndDate() {
            const plan = document.getElementById("membership_type").value;
            const startDate = new Date(document.getElementById("start_date").value);
            const priceInput = document.getElementById("price");
            const endDateInput = document.getElementById("end_date");

            let price = 0;
            let monthsToAdd = 0;

            switch (plan) {
                case "Monthly":
                    price = 1000;
                    monthsToAdd = 1;
                    break;
                case "Quarterly":
                    price = 2700;
                    monthsToAdd = 3;
                    break;
                case "Half-Yearly":
                    price = 5000;
                    monthsToAdd = 6;
                    break;
                case "Yearly":
                    price = 9000;
                    monthsToAdd = 12;
                    break;
            }

            priceInput.value = price;

            if (!isNaN(startDate.getTime())) {
                const endDate = new Date(startDate);
                endDate.setMonth(endDate.getMonth() + monthsToAdd);

                const formattedEndDate = endDate.toISOString().split('T')[0];
                endDateInput.value = formattedEndDate;
            }
        }
    </script>
</body>

</html>