<?php
session_start();
include 'assets/config/connect.php';

$error = '';
$product = null;
$product_images = [];

// Get product ID from URL
if (isset($_GET['id'])) {
    $product_id = (int) $_GET['id'];

    // Fetch product data
    $product_sql = "SELECT * FROM products WHERE id = $product_id";
    $product_result = mysqli_query($conn, $product_sql);
    $product = mysqli_fetch_assoc($product_result);

    if (!$product) {
        $_SESSION['error'] = "Product not found!";
        header("Location: product-list.php");
        exit();
    }

    // Fetch product images
    $images_sql = "SELECT * FROM product_images WHERE product_id = $product_id ORDER BY is_primary DESC, id ASC";
    $images_result = mysqli_query($conn, $images_sql);
    while ($image = mysqli_fetch_assoc($images_result)) {
        $product_images[] = $image;
    }
} else {
    $_SESSION['error'] = "No product ID specified!";
    header("Location: product-list.php");
    exit();
}

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $sku = $_POST['sku'];
    $name = $_POST['name'];
    $description = $_POST['description'];
    $price = $_POST['price'];
    $stock_quantity = $_POST['stock_quantity'];
    $weight_value = $_POST['weight_value'];
    $weight_unit = $_POST['weight_unit'];

    // Check if SKU already exists (excluding current product)
    $check_sku = $conn->prepare("SELECT id FROM products WHERE sku = ? AND id != ?");
    $check_sku->bind_param("si", $sku, $product_id);
    $check_sku->execute();
    $check_sku->store_result();

    if ($check_sku->num_rows > 0) {
        $error = "SKU already exists. Please use a different SKU.";
    } else {
        // Update product in database
        $stmt = $conn->prepare("UPDATE products SET sku=?, name=?, description=?, price=?, stock_quantity=?, weight_value=?, weight_unit=?, updated_at=NOW() WHERE id=?");
        $stmt->bind_param("sssdisdi", $sku, $name, $description, $price, $stock_quantity, $weight_value, $weight_unit, $product_id);

        if ($stmt->execute()) {
            // Handle new image uploads
            if (!empty($_FILES['product_images']['name'][0])) {
                $upload_dir = "assets/uploads/products/";
                if (!is_dir($upload_dir)) {
                    mkdir($upload_dir, 0777, true);
                }

                $uploaded_images = 0;
                $max_images = 5;
                $existing_images_count = count($product_images);

                foreach ($_FILES['product_images']['tmp_name'] as $key => $tmp_name) {
                    if ($uploaded_images + $existing_images_count >= $max_images)
                        break;

                    $file_name = $_FILES['product_images']['name'][$key];
                    $file_size = $_FILES['product_images']['size'][$key];
                    $file_tmp = $_FILES['product_images']['tmp_name'][$key];
                    $file_type = $_FILES['product_images']['type'][$key];

                    // Check file size (max 2MB)
                    if ($file_size > 2097152) {
                        $error .= "File $file_name is too large. Maximum size is 2MB.<br>";
                        continue;
                    }

                    // Check if file is an image
                    $allowed_types = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
                    if (!in_array($file_type, $allowed_types)) {
                        $error .= "File $file_name is not a valid image type.<br>";
                        continue;
                    }

                    // Generate unique filename
                    $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
                    $new_filename = "product_" . $product_id . "_" . time() . "_" . $key . "." . $file_ext;
                    $file_path = $upload_dir . $new_filename;

                    // Move uploaded file
                    if (move_uploaded_file($file_tmp, $file_path)) {
                        // Set as primary only if no images exist yet
                        $is_primary = ($existing_images_count == 0 && $key == 0) ? 1 : 0;

                        // Save image info to database
                        $img_stmt = $conn->prepare("INSERT INTO product_images (product_id, image_path, is_primary) VALUES (?, ?, ?)");
                        $img_stmt->bind_param("isi", $product_id, $file_path, $is_primary);
                        $img_stmt->execute();
                        $img_stmt->close();

                        $uploaded_images++;
                    } else {
                        $error .= "Failed to upload $file_name.<br>";
                    }
                }
            }

            // Handle image deletions
            if (!empty($_POST['delete_images'])) {
                foreach ($_POST['delete_images'] as $image_id) {
                    $image_id = (int) $image_id;

                    // Get image path for deletion from server
                    $img_sql = "SELECT image_path FROM product_images WHERE id = $image_id";
                    $img_result = mysqli_query($conn, $img_sql);
                    $img_data = mysqli_fetch_assoc($img_result);

                    if ($img_data && file_exists($img_data['image_path'])) {
                        unlink($img_data['image_path']);
                    }

                    // Delete from database
                    $delete_sql = "DELETE FROM product_images WHERE id = $image_id";
                    mysqli_query($conn, $delete_sql);

                    // If we deleted a primary image, set a new one
                    $primary_check = "SELECT COUNT(*) as count FROM product_images WHERE product_id = $product_id AND is_primary = 1";
                    $primary_result = mysqli_query($conn, $primary_check);
                    $primary_data = mysqli_fetch_assoc($primary_result);

                    if ($primary_data['count'] == 0) {
                        $set_primary = "UPDATE product_images SET is_primary = 1 WHERE product_id = $product_id LIMIT 1";
                        mysqli_query($conn, $set_primary);
                    }
                }
            }

            // Handle primary image change
            if (!empty($_POST['primary_image'])) {
                $primary_image_id = (int) $_POST['primary_image'];

                // Reset all images to non-primary
                $reset_sql = "UPDATE product_images SET is_primary = 0 WHERE product_id = $product_id";
                mysqli_query($conn, $reset_sql);

                // Set the selected image as primary
                $set_primary_sql = "UPDATE product_images SET is_primary = 1 WHERE id = $primary_image_id AND product_id = $product_id";
                mysqli_query($conn, $set_primary_sql);
            }

            $_SESSION['success'] = "Product updated successfully!";
            header("Location: product-list.php");
            exit();
        } else {
            $error = "Error updating product: " . $conn->error;
        }

        $stmt->close();
    }

    $check_sku->close();
}
?>

<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Gym - Edit Product</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/logo-sm.png">

    <!-- Bootstrap Css -->
    <link href="assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />

    <!-- Summernote CSS for rich text editor -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">

    <style>
        .error-message {
            color: #dc3545;
            font-size: 0.875em;
            margin-top: 0.25rem;
        }

        .is-invalid {
            border-color: #dc3545 !important;
        }

        .image-preview-container {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-top: 10px;
        }

        .image-preview {
            width: 100px;
            height: 100px;
            border: 1px solid #ddd;
            border-radius: 4px;
            padding: 4px;
            position: relative;
        }

        .image-preview img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .remove-image {
            position: absolute;
            top: -10px;
            right: -10px;
            background: #dc3545;
            color: white;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            line-height: 20px;
            text-align: center;
            cursor: pointer;
            font-size: 12px;
        }

        .existing-image {
            position: relative;
            margin-bottom: 15px;
        }

        .primary-badge {
            position: absolute;
            top: 5px;
            left: 5px;
            background: #28a745;
            color: white;
            padding: 2px 5px;
            border-radius: 3px;
            font-size: 10px;
        }

        .image-controls {
            margin-top: 5px;
            text-align: center;
        }
    </style>
</head>

<body data-sidebar="dark">
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'assets/config/header.php' ?>
        <?php include 'assets/config/sidebar.php' ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="page-title-box">
                                <h4>Products</h4>
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="product-list.php">Product List</a></li>
                                    <li class="breadcrumb-item active">Edit Product</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="card-title">Edit Product</h4>
                                    <p class="card-title-desc">Update product details carefully</p>

                                    <?php if (!empty($error)): ?>
                                        <div class="alert alert-danger" role="alert">
                                            <?php echo $error; ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (isset($_SESSION['success'])): ?>
                                        <div class="alert alert-success">
                                            <?= $_SESSION['success'];
                                            unset($_SESSION['success']); ?></div>
                                    <?php endif; ?>

                                    <form id="productForm" method="POST" action="" enctype="multipart/form-data">
                                        <div class="row">
                                            <!-- SKU -->
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">SKU</label>
                                                <input type="text" class="form-control" name="sku"
                                                    value="<?= htmlspecialchars($product['sku']) ?>" required>
                                            </div>

                                            <!-- Product Name -->
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Product Name</label>
                                                <input type="text" class="form-control" name="name"
                                                    value="<?= htmlspecialchars($product['name']) ?>" required>
                                            </div>

                                            <!-- Price -->
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Price ($)</label>
                                                <input type="number" class="form-control" name="price" step="0.01"
                                                    min="0" value="<?= $product['price'] ?>" required>
                                            </div>

                                            <!-- Stock Quantity -->
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Stock Quantity</label>
                                                <input type="number" class="form-control" name="stock_quantity" min="0"
                                                    value="<?= $product['stock_quantity'] ?>" required>
                                            </div>

                                            <!-- Weight -->
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">Weight Value</label>
                                                <input type="number" class="form-control" name="weight_value"
                                                    step="0.01" min="0" value="<?= $product['weight_value'] ?>"
                                                    required>
                                            </div>

                                            <!-- Weight Unit -->
                                            <div class="col-md-2 mb-3">
                                                <label class="form-label">Unit</label>
                                                <select class="form-control" name="weight_unit" required>
                                                    <option value="g" <?= $product['weight_unit'] == 'g' ? 'selected' : '' ?>>g</option>
                                                    <option value="kg" <?= $product['weight_unit'] == 'kg' ? 'selected' : '' ?>>kg</option>
                                                    <option value="lb" <?= $product['weight_unit'] == 'lb' ? 'selected' : '' ?>>lb</option>
                                                    <option value="oz" <?= $product['weight_unit'] == 'oz' ? 'selected' : '' ?>>oz</option>
                                                </select>
                                            </div>

                                            <!-- Existing Product Images -->
                                            <div class="col-md-12 mb-3">
                                                <label class="form-label">Existing Images</label>
                                                <div class="row">
                                                    <?php if (!empty($product_images)): ?>
                                                        <?php foreach ($product_images as $image): ?>
                                                            <div class="col-md-2 mb-3">
                                                                <div class="existing-image">
                                                                    <img src="<?= htmlspecialchars($image['image_path']) ?>"
                                                                        class="img-thumbnail"
                                                                        style="width: 100px; height: 100px; object-fit: cover;">
                                                                    <?php if ($image['is_primary']): ?>
                                                                        <span class="primary-badge">Primary</span>
                                                                    <?php endif; ?>
                                                                    <div class="image-controls">
                                                                        <div class="form-check">
                                                                            <input class="form-check-input" type="radio"
                                                                                name="primary_image" value="<?= $image['id'] ?>"
                                                                                id="primary_<?= $image['id'] ?>"
                                                                                <?= $image['is_primary'] ? 'checked' : '' ?>>
                                                                            <label class="form-check-label"
                                                                                for="primary_<?= $image['id'] ?>">Set
                                                                                Primary</label>
                                                                        </div>
                                                                        <div class="form-check">
                                                                            <input class="form-check-input" type="checkbox"
                                                                                name="delete_images[]"
                                                                                value="<?= $image['id'] ?>"
                                                                                id="delete_<?= $image['id'] ?>">
                                                                            <label class="form-check-label text-danger"
                                                                                for="delete_<?= $image['id'] ?>">Delete</label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <div class="col-12">
                                                            <p class="text-muted">No images uploaded yet.</p>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <!-- New Product Images -->
                                            <div class="col-md-12 mb-3">
                                                <label class="form-label">Add New Images (Max 5 images, 2MB
                                                    each)</label>
                                                <input type="file" class="form-control" name="product_images[]" multiple
                                                    accept="image/*" onchange="previewImages(this)">
                                                <div class="image-preview-container" id="imagePreviewContainer"></div>
                                            </div>

                                            <!-- Description -->
                                            <div class="col-md-12 mb-3">
                                                <label class="form-label">Description</label>
                                                <textarea class="form-control" id="summernote" name="description"
                                                    rows="6"><?= htmlspecialchars($product['description']) ?></textarea>
                                            </div>

                                            <!-- Submit Button -->
                                            <div class="col-md-12 text-center mt-3">
                                                <button type="submit" class="btn btn-primary">Update Product</button>
                                                <a href="product-list.php" class="btn btn-secondary">Cancel</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div> <!-- container-fluid -->
            </div>
            <!-- End Page-content -->
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <!-- JAVASCRIPT -->
    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/libs/metismenu/metisMenu.min.js"></script>
    <script src="assets/libs/simplebar/simplebar.min.js"></script>
    <script src="assets/libs/node-waves/waves.min.js"></script>
    <script src="assets/libs/jquery-sparkline/jquery.sparkline.min.js"></script>

    <!-- Summernote JS for rich text editor -->
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>

    <script src="assets/js/app.js"></script>

    <script>
        // Initialize summernote editor with heading options
        $(document).ready(function () {
            $('#summernote').summernote({
                height: 300,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['fontname', ['fontname']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ],
                styleTags: [
                    'p',
                    { title: 'Blockquote', tag: 'blockquote', className: 'blockquote', value: 'blockquote' },
                    'pre', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'
                ],
                fontNames: [
                    'Arial', 'Arial Black', 'Comic Sans MS', 'Courier New',
                    'Helvetica Neue', 'Helvetica', 'Impact', 'Lucida Grande',
                    'Tahoma', 'Times New Roman', 'Verdana'
                ],
                fontSizes: ['8', '9', '10', '11', '12', '14', '16', '18', '20', '24', '30', '36', '48'],
                lineHeights: ['1.0', '1.2', '1.4', '1.5', '1.6', '1.8', '2.0', '3.0']
            });
        });

        // Image preview functionality
        function previewImages(input) {
            const previewContainer = document.getElementById('imagePreviewContainer');
            previewContainer.innerHTML = '';

            if (input.files && input.files.length > 0) {
                const files = Array.from(input.files).slice(0, 5); // Limit to 5 files

                files.forEach((file, index) => {
                    if (file.size > 2097152) { // 2MB limit
                        alert(`File ${file.name} is too large. Maximum size is 2MB.`);
                        return;
                    }

                    const reader = new FileReader();

                    reader.onload = function (e) {
                        const div = document.createElement('div');
                        div.className = 'image-preview';
                        div.innerHTML = `
                            <img src="${e.target.result}" alt="Preview">
                            <span class="remove-image" onclick="removeImagePreview(${index})">×</span>
                        `;
                        previewContainer.appendChild(div);
                    }

                    reader.readAsDataURL(file);
                });
            }
        }

        function removeImagePreview(index) {
            // Create a new DataTransfer object
            const dt = new DataTransfer();
            const input = document.querySelector('input[name="product_images[]"]');

            // Add all files except the one to remove
            for (let i = 0; i < input.files.length; i++) {
                if (i !== index) {
                    dt.items.add(input.files[i]);
                }
            }

            // Update the files in the input
            input.files = dt.files;

            // Refresh the preview
            previewImages(input);
        }
    </script>
</body>

</html>