<?php
// Set the timezone to Indian Standard Time for accurate date filtering
date_default_timezone_set('Asia/Kolkata');

include 'assets/config/connect.php';
session_start();

$user_id = $_SESSION['id'];

if (!$user_id) {
    header("Location: login.php");
    exit();
}

// ================== Fetch Data ==================

// Total products
$product_sql = "SELECT COUNT(*) AS total_products FROM products";
$product_result = mysqli_query($conn, $product_sql);
$product_row = mysqli_fetch_assoc($product_result);
$total_products = $product_row['total_products'];

// Total members
$member_sql = "SELECT COUNT(*) AS total_members FROM members";
$member_result = mysqli_query($conn, $member_sql);
$member_row = mysqli_fetch_assoc($member_result);
$total_members = $member_row['total_members'];

// Members whose membership ends in next 10 days
$today = date('Y-m-d');
$next_10_days = date('Y-m-d', strtotime('+10 days'));
$expiring_sql = "SELECT COUNT(*) AS expiring_members 
                 FROM members 
                 WHERE end_date IS NOT NULL 
                 AND end_date BETWEEN '$today' AND '$next_10_days'";
$expiring_result = mysqli_query($conn, $expiring_sql);
$expiring_row = mysqli_fetch_assoc($expiring_result);
$expiring_members = $expiring_row['expiring_members'];

?>

<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Bootstrap Css -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" />
     <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/logo-sm.png">

    <!-- Bootstrap Css -->
    <link href="assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />

    <style>
        .card-stat {
            transition: all 0.3s ease;
            cursor: pointer;
            border-radius: 15px;
        }

        .card-stat:hover {
            transform: translateY(-8px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        }

        .card-icon {
            font-size: 2.5rem;
            opacity: 0.8;
        }

        .bg-gradient-primary {
            background: linear-gradient(45deg, #4e73df, #1cc88a);
        }

        .bg-gradient-danger {
            background: linear-gradient(45deg, #e74a3b, #f6c23e);
        }

        .bg-gradient-info {
            background: linear-gradient(45deg, #36b9cc, #6610f2);
        }

        .text-white h3 {
            font-weight: bold;
        }
    </style>
</head>

<body data-sidebar="dark">
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'assets/config/header.php' ?>
        <?php include 'assets/config/sidebar.php' ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row mb-4">
                        <div class="col-sm-6">
                            <div class="page-title-box">
                                <h4 class="mb-0">Dashboard</h4>
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="#">Barbell Life</a></li>
                                    <li class="breadcrumb-item active">Dashboard</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <!-- Dashboard Cards -->
                    <div class="row g-4">
                        <!-- Total Products -->
                        <div class="col-md-4">
                            <a href="product-list" class="card-link">
                                <div class="card card-stat bg-gradient-info text-white p-4">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h5>Total Products</h5>
                                            <h3><?php echo $total_products; ?></h3>
                                        </div>
                                        <i class="mdi mdi-dumbbell card-icon"></i>
                                    </div>
                                </div>
                            </a>
                        </div>

                        <!-- Total Members -->
                        <div class="col-md-4">
                            <a href="memberlist" class="card-link">
                                <div class="card card-stat bg-gradient-primary text-white p-4">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h5>Total Members</h5>
                                            <h3><?php echo $total_members; ?></h3>
                                        </div>
                                        <i class="mdi mdi-account-group card-icon"></i>
                                    </div>
                                </div>
                            </a>
                        </div>

                        <!-- Expiring Members -->
                        <div class="col-md-4">
                            <a href="memberlist" class="card-link">
                                <div class="card card-stat bg-gradient-danger text-white p-4">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h5>Expiring in 10 Days</h5>
                                            <h3><?php echo $expiring_members; ?></h3>
                                        </div>
                                        <i class="mdi mdi-calendar-alert card-icon"></i>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                    <!-- end row -->
                </div>
                <!-- container-fluid -->
            </div>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/libs/metismenu/metisMenu.min.js"></script>
    <script src="assets/libs/simplebar/simplebar.min.js"></script>
    <script src="assets/libs/node-waves/waves.min.js"></script>
    <script src="assets/js/app.js"></script>
</body>

</html>
