<?php
session_start();
include 'assets/config/connect.php';

// Get form data
$email = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';

// Basic validation
if (empty($email) || empty($password)) {
    header("Location: login.php?error=Email and password are required");
    exit();
}

// Check in admin table first
$sql = "SELECT * FROM admin WHERE email = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    // Admin user found
    $user = $result->fetch_assoc();
    
    if (password_verify($password, $user['password'])) {
        $_SESSION['id'] = $user['id'];
        $_SESSION['user'] = $user;
        $_SESSION['email'] = strtolower(trim($user['email']));
        $_SESSION['role'] = 'admin'; // Set role as admin
        
        header("Location: index.php");
        exit();
    } else {
        header("Location: login.php?error=Invalid password");
        exit();
    }
} else {
    // Check in members table if not found in admin
    $sql = "SELECT * FROM members WHERE email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        
        if (password_verify($password, $user['password'])) {
            $_SESSION['id'] = $user['id'];
            $_SESSION['user'] = $user;
            $_SESSION['email'] = strtolower(trim($user['email']));
            $_SESSION['role'] = 'member'; // Set role as member
            
            header("Location: index.php");
            exit();
        } else {
            header("Location: login.php?error=Invalid password");
            exit();
        }
    } else {
        header("Location: login.php?error=User not found");
        exit();
    }
}
?>