<?php
include 'assets/config/connect.php';
session_start();

// Check if member ID is provided
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header('Location: members_list.php');
    exit();
}

$member_id = $_GET['id'];

// Fetch member details
$sql = "SELECT * FROM members WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $member_id);
$stmt->execute();
$result = $stmt->get_result();
$member = $result->fetch_assoc();

if (!$member) {
    header('Location: members_list.php');
    exit();
}

// Fetch body measurements
$measurements_sql = "SELECT * FROM measurements WHERE member_id = ? ORDER BY measured_on DESC";
$stmt = $conn->prepare($measurements_sql);
$stmt->bind_param("i", $member_id);
$stmt->execute();
$measurements_result = $stmt->get_result();
$measurements = $measurements_result->fetch_all(MYSQLI_ASSOC);

// Handle measurement comparison
$comparison_data = null;
if (isset($_POST['compare'])) {
    $measurement1_id = $_POST['measurement1'];
    $measurement2_id = $_POST['measurement2'];

    if ($measurement1_id && $measurement2_id) {
        $compare_sql = "SELECT * FROM measurements WHERE id IN (?, ?) ORDER BY measured_on DESC";
        $stmt = $conn->prepare($compare_sql);
        $stmt->bind_param("ii", $measurement1_id, $measurement2_id);
        $stmt->execute();
        $comparison_result = $stmt->get_result();
        $comparison_data = $comparison_result->fetch_all(MYSQLI_ASSOC);
    }
}
?>

<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title><?= htmlspecialchars($member['name']) ?> - Profile</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/logo-sm.png">

    <!-- Bootstrap Css -->
    <link href="assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
        .profile-header {
            background: linear-gradient(135deg, #6e8efb, #a777e3);
            color: white;
            padding: 30px 0;
            margin-bottom: 30px;
        }

        .profile-img-container {
            width: 150px;
            height: 150px;
            margin: 0 auto;
            border: 5px solid white;
            border-radius: 50%;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .profile-img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .profile-card {
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            margin-bottom: 30px;
        }

        .profile-card .card-body {
            padding: 30px;
        }

        .detail-item {
            margin-bottom: 15px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }

        .detail-item:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }

        .detail-label {
            font-weight: 600;
            color: #6c757d;
        }

        .detail-value {
            color: #495057;
        }

        .badge-status {
            font-size: 0.85rem;
            padding: 5px 10px;
            border-radius: 20px;
        }

        .measurement-value {
            font-weight: bold;
            color: #495057;
        }

        .measurement-unit {
            color: #6c757d;
            font-size: 0.9em;
        }

        .measurement-history {
            max-height: 300px;
            overflow-y: auto;
        }

        .comparison-card {
            background-color: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
        }

        .improvement {
            color: #28a745;
            font-weight: bold;
        }

        .decline {
            color: #dc3545;
            font-weight: bold;
        }

        .no-change {
            color: #6c757d;
            font-weight: bold;
        }

        @media (max-width: 768px) {
            .profile-img-container {
                width: 120px;
                height: 120px;
            }
        }
    </style>
</head>

<body data-sidebar="dark">
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'assets/config/header.php' ?>
        <?php include 'assets/config/sidebar.php' ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-flex align-items-center justify-content-between">
                                <h4 class="mb-0">Member Profile</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="members_list.php">Members</a></li>
                                        <li class="breadcrumb-item active"><?= htmlspecialchars($member['name']) ?></li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="profile-header text-center">
                        <div class="profile-img-container mb-3">
                            <?php if (!empty($member['profile_photo'])): ?>
                                <img src="<?= htmlspecialchars($member['profile_photo']) ?>" alt="Profile"
                                    class="profile-img">
                            <?php else: ?>
                                <i class="fas fa-user-circle fa-5x text-light"></i>
                            <?php endif; ?>
                        </div>
                        <h3 class="text-white"><?= htmlspecialchars($member['name']) ?></h3>
                        <span
                            class="badge-status badge-<?= strtolower($member['status']) === 'active' ? 'success' : 'danger' ?>">
                            <?= htmlspecialchars($member['status']) ?>
                        </span>
                    </div>

                    <div class="row">
                        <div class="col-lg-4">
                            <div class="profile-card card">
                                <div class="card-body">
                                    <h5 class="card-title mb-4">Personal Information</h5>

                                    <div class="detail-item">
                                        <div class="detail-label">Member ID</div>
                                        <div class="detail-value"><?= htmlspecialchars($member['id']) ?></div>
                                    </div>

                                    <div class="detail-item">
                                        <div class="detail-label">Phone Number</div>
                                        <div class="detail-value"><?= htmlspecialchars($member['phone']) ?></div>
                                    </div>

                                    <div class="detail-item">
                                        <div class="detail-label">Email</div>
                                        <div class="detail-value"><?= htmlspecialchars($member['email']) ?></div>
                                    </div>

                                    <div class="detail-item">
                                        <div class="detail-label">Address</div>
                                        <div class="detail-value"><?= htmlspecialchars($member['address']) ?></div>
                                    </div>
                                </div>
                            </div>

                            <!-- Current Body Measurements -->
                            <div class="profile-card card">
                                <div class="card-body">
                                    <h5 class="card-title mb-4">Current Body Stats</h5>

                                    <?php if (!empty($measurements)): ?>
                                        <?php $latest = $measurements[0]; ?>
                                        <div class="row text-center">
                                            <div class="col-4 mb-3">
                                                <div class="detail-label">Height</div>
                                                <div class="measurement-value"><?= $latest['height'] ?></div>
                                                <div class="measurement-unit">cm</div>
                                            </div>
                                            <div class="col-4 mb-3">
                                                <div class="detail-label">Weight</div>
                                                <div class="measurement-value"><?= $latest['weight'] ?></div>
                                                <div class="measurement-unit">kg</div>
                                            </div>
                                            <div class="col-4 mb-3">
                                                <div class="detail-label">Chest</div>
                                                <div class="measurement-value"><?= $latest['chest'] ?></div>
                                                <div class="measurement-unit">cm</div>
                                            </div>
                                        </div>
                                        <div class="row text-center">
                                            <div class="col-4 mb-3">
                                                <div class="detail-label">Biceps</div>
                                                <div class="measurement-value"><?= $latest['biceps'] ?></div>
                                                <div class="measurement-unit">cm</div>
                                            </div>
                                            <div class="col-4 mb-3">
                                                <div class="detail-label">Waist</div>
                                                <div class="measurement-value"><?= $latest['waist'] ?></div>
                                                <div class="measurement-unit">cm</div>
                                            </div>
                                            <div class="col-4 mb-3">
                                                <div class="detail-label">Last Measured</div>
                                                <div class="measurement-value">
                                                    <?= date('d M Y', strtotime($latest['measured_on'])) ?></div>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="alert alert-info">No body measurements recorded yet.</div>
                                    <?php endif; ?>

                                    <div class="text-center mt-3">
                                        <a href="add_measurement.php?member_id=<?= $member['id'] ?>"
                                            class="btn btn-primary">
                                            <i class="fas fa-plus me-2"></i> Add New Measurement
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <!-- Membership Details -->
                            <div class="profile-card card">
                                <div class="card-body">
                                    <h5 class="card-title mb-4">Membership Details</h5>

                                    <div class="detail-item">
                                        <div class="detail-label">Membership Type</div>
                                        <div class="detail-value"><?= htmlspecialchars($member['membership_type']) ?>
                                        </div>
                                    </div>

                                    <div class="detail-item">
                                        <div class="detail-label">Start Date</div>
                                        <div class="detail-value"><?= date('d M Y', strtotime($member['start_date'])) ?>
                                        </div>
                                    </div>

                                    <div class="detail-item">
                                        <div class="detail-label">End Date</div>
                                        <div class="detail-value"><?= date('d M Y', strtotime($member['end_date'])) ?>
                                        </div>
                                    </div>

                                    <div class="detail-item">
                                        <div class="detail-label">Amount Paid</div>
                                        <div class="detail-value">₹<?= number_format($member['amount'], 2) ?></div>
                                    </div>

                                    <div class="detail-item">
                                        <div class="detail-label">Registration Date</div>
                                        <div class="detail-value">
                                            <?= date('d M Y, h:i A', strtotime($member['created_at'])) ?></div>
                                    </div>
                                </div>
                            </div>

                            <!-- Measurement History -->
                            <div class="profile-card card">
                                <div class="card-body">
                                    <h5 class="card-title mb-4">Measurement History</h5>

                                    <?php if (!empty($measurements)): ?>
                                        <div class="measurement-history">
                                            <table class="table table-sm">
                                                <thead>
                                                    <tr>
                                                        <th>Date</th>
                                                        <th>Weight</th>
                                                        <th>Chest</th>
                                                        <th>Waist</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($measurements as $measurement): ?>
                                                        <tr>
                                                            <td><?= date('d M Y', strtotime($measurement['measured_on'])) ?>
                                                            </td>
                                                            <td><?= $measurement['weight'] ?> kg</td>
                                                            <td><?= $measurement['chest'] ?> cm</td>
                                                            <td><?= $measurement['waist'] ?> cm</td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    <?php else: ?>
                                        <div class="alert alert-info">No measurement history available.</div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <!-- Compare Measurements -->
                            <div class="profile-card card">
                                <div class="card-body">
                                    <h5 class="card-title mb-4">Compare Measurements</h5>

                                    <?php if (count($measurements) > 1): ?>
                                        <form method="post">
                                            <!-- Hidden field to send member_id -->
                                            <input type="hidden" name="member_id" value="<?= $member_id ?>">

                                            <div class="mb-3">
                                                <label class="form-label">First Measurement</label>
                                                <select class="form-select" name="measurement1" required>
                                                    <?php foreach ($measurements as $m): ?>
                                                        <option value="<?= $m['id'] ?>">
                                                            <?= date('d M Y', strtotime($m['measured_on'])) ?> -
                                                            Weight: <?= $m['weight'] ?>kg
                                                        </option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Second Measurement</label>
                                                <select class="form-select" name="measurement2" required>
                                                    <?php foreach ($measurements as $m): ?>
                                                        <option value="<?= $m['id'] ?>">
                                                            <?= date('d M Y', strtotime($m['measured_on'])) ?> -
                                                            Weight: <?= $m['weight'] ?>kg
                                                        </option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                            <button type="submit" name="compare" class="btn btn-primary w-100">
                                                <i class="fas fa-exchange-alt me-2"></i> Compare
                                            </button>
                                        </form>

                                        <?php if ($comparison_data && count($comparison_data) == 2): ?>
                                            <?php
                                            $m1 = $comparison_data[0];
                                            $m2 = $comparison_data[1];

                                            // Calculate differences
                                             $weight_diff = $m1['weight'] - $m2['weight'];
    $chest_diff = $m1['chest'] - $m2['chest'];
    $biceps_diff = $m1['biceps'] - $m2['biceps'];
    $waist_diff = $m1['waist'] - $m2['waist'];
                                            ?>

                                           <div class="comparison-card mt-4">
        <h6 class="text-center mb-3">Comparison Results</h6>
        <div class="row text-center">
            <div class="col-6">
                <div class="fw-bold"><?= date('d M Y', strtotime($m2['measured_on'])) ?></div>
            </div>
            <div class="col-6">
                <div class="fw-bold"><?= date('d M Y', strtotime($m1['measured_on'])) ?></div>
            </div>
        </div>
        
        <div class="mt-3">
            <div class="d-flex justify-content-between mb-2">
                <span>Weight:</span>
                <span>
                    <?= $m2['weight'] ?>kg → <?= $m1['weight'] ?>kg 
                    <span class="<?= $weight_diff > 0 ? 'improvement' : ($weight_diff < 0 ? 'decline' : 'no-change') ?>">
                        (<?= $weight_diff > 0 ? '+' : '' ?><?= $weight_diff ?>kg)
                    </span>
                </span>
            </div>
            <div class="d-flex justify-content-between mb-2">
                <span>Chest:</span>
                <span>
                    <?= $m2['chest'] ?>cm → <?= $m1['chest'] ?>cm 
                    <span class="<?= $chest_diff > 0 ? 'improvement' : ($chest_diff < 0 ? 'decline' : 'no-change') ?>">
                        (<?= $chest_diff > 0 ? '+' : '' ?><?= $chest_diff ?>cm)
                    </span>
                </span>
            </div>
            <div class="d-flex justify-content-between mb-2">
                <span>Biceps:</span>
                <span>
                    <?= $m2['biceps'] ?>cm → <?= $m1['biceps'] ?>cm 
                    <span class="<?= $biceps_diff > 0 ? 'improvement' : ($biceps_diff < 0 ? 'decline' : 'no-change') ?>">
                        (<?= $biceps_diff > 0 ? '+' : '' ?><?= $biceps_diff ?>cm)
                    </span>
                </span>
            </div>
            <div class="d-flex justify-content-between">
                <span>Waist:</span>
                <span>
                    <?= $m2['waist'] ?>cm → <?= $m1['waist'] ?>cm 
                    <span class="<?= $waist_diff > 0 ? 'decline' : ($waist_diff < 0 ? 'improvement' : 'no-change') ?>">
                        (<?= $waist_diff > 0 ? '+' : '' ?><?= $waist_diff ?>cm)
                    </span>
                </span>
            </div>
        </div>
        
        <canvas id="comparisonChart" class="mt-3" height="200"></canvas>
    </div>

                                                <canvas id="comparisonChart" class="mt-3" height="200"></canvas>
                                            </div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <div class="alert alert-info">You need at least 2 measurements to compare.</div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Quick Actions -->
                            <div class="profile-card card">
                                <div class="card-body">
                                    <h5 class="card-title mb-4">Quick Actions</h5>

                                    <div class="d-grid gap-2">
                                        <a href="edit_member.php?id=<?= $member['id'] ?>" class="btn btn-primary">
                                            <i class="fas fa-edit me-2"></i> Edit Profile
                                        </a>

                                        <a href="members_list.php" class="btn btn-outline-secondary">
                                            <i class="fas fa-arrow-left me-2"></i> Back to List
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div> <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-12">
                            ©
                            <script>document.write(new Date().getFullYear())</script> Barbell Life <span
                                class="d-none d-sm-inline-block"> - Crafted with <i
                                    class="mdi mdi-heart text-danger"></i> by Gym .</span>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <!-- JAVASCRIPT -->
    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/libs/metismenu/metisMenu.min.js"></script>
    <script src="assets/libs/simplebar/simplebar.min.js"></script>
    <script src="assets/libs/node-waves/waves.min.js"></script>
    <script src="assets/libs/jquery-sparkline/jquery.sparkline.min.js"></script>
    <script src="assets/libs/parsleyjs/parsley.min.js"></script>
    <script src="assets/js/pages/form-validation.init.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
    <!-- Font Awesome for icons -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/js/all.min.js"></script>

    <?php if ($comparison_data && count($comparison_data) == 2): ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const ctx = document.getElementById('comparisonChart').getContext('2d');
                const comparisonChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: ['Weight', 'Chest', 'Biceps', 'Waist'],
                        datasets: [
                            {
                                label: '<?= date('d M Y', strtotime($m1['measured_on'])) ?>',
                                data: [
                                    <?= $m1['weight'] ?>,
                                    <?= $m1['chest'] ?>,
                                    <?= $m1['biceps'] ?>,
                                    <?= $m1['waist'] ?>
                                ],
                                backgroundColor: 'rgba(54, 162, 235, 0.5)',
                                borderColor: 'rgba(54, 162, 235, 1)',
                                borderWidth: 1
                            },
                            {
                                label: '<?= date('d M Y', strtotime($m2['measured_on'])) ?>',
                                data: [
                                    <?= $m2['weight'] ?>,
                                    <?= $m2['chest'] ?>,
                                    <?= $m2['biceps'] ?>,
                                    <?= $m2['waist'] ?>
                                ],
                                backgroundColor: 'rgba(75, 192, 192, 0.5)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            }
                        ]
                    },
                    options: {
                        responsive: true,
                        scales: {
                            y: {
                                beginAtZero: false
                            }
                        }
                    }
                });
            });
        </script>
    <?php endif; ?>
</body>

</html>