<?php
include 'assets/config/connect.php';
session_start();

// Calculate membership status based on end_date
function calculateMembershipStatus($end_date)
{
    $today = new DateTime();
    $end_date = new DateTime($end_date);
    $interval = $today->diff($end_date);
    $days_left = $interval->days;

    if ($interval->invert) { // Past due
        return ['status' => 'Expired', 'days_left' => 0, 'class' => 'danger'];
    } elseif ($days_left <= 10) {
        return ['status' => "Expires in $days_left days", 'days_left' => $days_left, 'class' => 'warning'];
    } else {
        return ['status' => 'Active', 'days_left' => $days_left, 'class' => 'success'];
    }
}

// Handle membership renewal if form submitted
if (isset($_POST['renew_member'])) {
    $member_id = $_POST['member_id'];
    $membership_type = $_POST['membership_type'];
    $amount = $_POST['amount'];

    // Calculate new end date based on membership type
    $start_date = date('Y-m-d');
    $end_date = date('Y-m-d', strtotime("+1 month"));
    if ($membership_type == 'Quarterly') {
        $end_date = date('Y-m-d', strtotime("+3 months"));
    } elseif ($membership_type == 'Yearly') {
        $end_date = date('Y-m-d', strtotime("+1 year"));
    }

    // Update member record
    $update_sql = "UPDATE members SET 
                  membership_type = '$membership_type',
                  start_date = '$start_date',
                  end_date = '$end_date',
                  amount = '$amount',
                  status = 'Active'
                  WHERE id = $member_id";

    if (mysqli_query($conn, $update_sql)) {
        // Log the renewal in history
        $history_sql = "INSERT INTO membership_history 
                       (member_id, renewal_date, membership_type, amount, start_date, end_date)
                       VALUES 
                       ($member_id, NOW(), '$membership_type', '$amount', '$start_date', '$end_date')";
        mysqli_query($conn, $history_sql);

        $_SESSION['success'] = "Membership renewed successfully!";
    } else {
        $_SESSION['error'] = "Error renewing membership: " . mysqli_error($conn);
    }
    header("Location: members-list.php");
    exit();
}

// fetch members data with calculated status
$sql = "SELECT *, 
       CASE 
           WHEN end_date < CURDATE() THEN 'Expired'
           WHEN DATEDIFF(end_date, CURDATE()) <= 10 THEN CONCAT('Expires in ', DATEDIFF(end_date, CURDATE()), ' days')
           ELSE 'Active'
       END AS calculated_status
       FROM members ORDER BY id DESC";
$result = mysqli_query($conn, $sql);
?>

<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Gym Members List</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/logo-sm.png">

    <!-- Bootstrap Css -->
    <link href="assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <style>
        .expiring-soon {
            background-color: #fff3cd !important;
        }

        .expired {
            background-color: #f8d7da !important;
        }

        .renew-btn {
            margin-top: 5px;
        }
    </style>
</head>

<body data-sidebar="dark">
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'assets/config/header.php' ?>
        <?php include 'assets/config/sidebar.php' ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="page-title-box">
                                <h4>Members Management</h4>
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item active">Manage your gym members</li>
                                </ol>
                            </div>
                        </div>
                        <div class="col-sm-6 text-end">
                            <a href="register-member" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Add New Member
                            </a>
                        </div>
                    </div>
                    <!-- end page title -->

                    <!-- Display alerts -->
                    <?php if (isset($_SESSION['success'])): ?>
                        <div class="alert alert-success"><?= $_SESSION['success'];
                        unset($_SESSION['success']); ?></div>
                    <?php endif; ?>
                    <?php if (isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger"><?= $_SESSION['error'];
                        unset($_SESSION['error']); ?></div>
                    <?php endif; ?>

                    <!-- Member Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-dark text-center">
                                <tr>
                                    <th>ID</th>
                                    <th>Profile</th>
                                    <th>Name</th>
                                    <th>Phone</th>
                                    <th>Address</th>
                                    <th>Start Date</th>
                                    <th>Status</th>
                                    <!-- <th>Registered At</th> -->
                                    <th>Membership</th>
                                    <th>End Date</th>
                                    <th>Amount</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody class="text-center">
                                <?php if ($result->num_rows > 0): ?>
                                    <?php while ($row = $result->fetch_assoc()): ?>
                                        <?php
                                        $status_info = calculateMembershipStatus($row['end_date']);
                                        $row_class = '';
                                        if ($status_info['status'] != 'Active') {
                                            $row_class = $status_info['status'] == 'Expired' ? 'expired' : 'expiring-soon';
                                        }
                                        ?>
                                        <tr class="<?= $row_class ?>">
                                            <td><?= $row['id'] ?></td>

                                            <!-- Profile Photo -->
                                            <td>
                                                <?php if (!empty($row['profile_photo'])): ?>
                                                    <img src="<?= htmlspecialchars($row['profile_photo']) ?>" alt="Profile"
                                                        width="50" height="50" class="rounded-circle">
                                                <?php else: ?>
                                                    <i class="fas fa-user-circle fa-2x text-muted"></i>
                                                <?php endif; ?>
                                            </td>

                                            <td><?= htmlspecialchars($row['name']) ?></td>
                                            <td><?= htmlspecialchars($row['phone']) ?></td>
                                            <td><?= htmlspecialchars($row['address']) ?></td>
                                            <td><?= date('d M Y', strtotime($row['start_date'])) ?></td>
                                            <td>
                                                <span class="badge bg-<?= $status_info['class'] ?>">
                                                    <?= $status_info['status'] ?>
                                                </span>
                                            </td>

                                            <td><?= htmlspecialchars($row['membership_type']) ?></td>
                                            <td><?= date('d M Y', strtotime($row['end_date'])) ?></td>
                                            <td>₹<?= number_format($row['amount'], 2) ?></td>
                                            <!-- Action Buttons -->
                                            <td>
                                                <!-- <div class="d-flex flex-column"> -->
                                                <a href="member_profile.php?id=<?= $row['id'] ?>"
                                                    class="btn btn-sm btn-info mb-1" title="View Profile">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="edit_member.php?id=<?= $row['id'] ?>"
                                                    class="btn btn-sm btn-primary mb-1" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <a href="#" onclick="confirmDelete(<?= $row['id'] ?>)"
                                                    class="btn btn-sm btn-danger mb-1" title="Delete">
                                                    <i class="fas fa-trash-alt"></i>
                                                </a>
                                                <?php if ($status_info['status'] == 'Expired' || $status_info['days_left'] <= 10): ?>
                                                    <button class="btn btn-sm btn-warning renew-btn" data-bs-toggle="modal"
                                                        data-bs-target="#renewModal" data-member-id="<?= $row['id'] ?>"
                                                        data-member-name="<?= htmlspecialchars($row['name']) ?>"
                                                        data-current-type="<?= htmlspecialchars($row['membership_type']) ?>"
                                                        data-current-amount="<?= $row['amount'] ?>">
                                                        <i class="fas fa-sync-alt"></i>
                                                    </button>
                                                <?php endif; ?>
                                                <!-- </div> -->
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="12" class="text-center">No members found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div> <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <!-- Renew Membership Modal -->
            <div class="modal fade" id="renewModal" tabindex="-1" aria-labelledby="renewModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="renewModalLabel">Renew Membership</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form method="POST" action="">
                            <div class="modal-body">
                                <input type="hidden" name="member_id" id="renew_member_id">
                                <div class="mb-3">
                                    <label for="member_name" class="form-label">Member Name</label>
                                    <input type="text" class="form-control" id="member_name" readonly>
                                </div>
                                <div class="mb-3">
                                    <label for="membership_type" class="form-label">Membership Type</label>
                                    <select class="form-select" id="membership_type" name="membership_type" required>
                                        <option value="Monthly">Monthly</option>
                                        <option value="Quarterly">Quarterly (3 Months)</option>
                                        <option value="Yearly">Yearly</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="amount" class="form-label">Amount</label>
                                    <input type="number" class="form-control" id="amount" name="amount" required>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" name="renew_member" class="btn btn-primary">Renew
                                    Membership</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-12">
                            ©
                            <script>document.write(new Date().getFullYear())</script> Barbell Life <span
                                class="d-none d-sm-inline-block"> - Crafted with <i
                                    class="mdi mdi-heart text-danger"></i> by Barbell Life.</span>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <!-- JAVASCRIPT -->
    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/libs/metismenu/metisMenu.min.js"></script>
    <script src="assets/libs/simplebar/simplebar.min.js"></script>
    <script src="assets/libs/node-waves/waves.min.js"></script>
    <script src="assets/libs/jquery-sparkline/jquery.sparkline.min.js"></script>
    <script src="assets/libs/parsleyjs/parsley.min.js"></script>
    <script src="assets/js/pages/form-validation.init.js"></script>
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
    <!-- Font Awesome for icons -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/js/all.min.js"></script>

    <script>
        // Delete confirmation
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = 'delete_member.php?id=' + id;
                }
            });
        }

        // Renew modal handler
        document.addEventListener('DOMContentLoaded', function () {
            var renewModal = document.getElementById('renewModal');
            renewModal.addEventListener('show.bs.modal', function (event) {
                var button = event.relatedTarget;
                var memberId = button.getAttribute('data-member-id');
                var memberName = button.getAttribute('data-member-name');
                var currentType = button.getAttribute('data-current-type');
                var currentAmount = button.getAttribute('data-current-amount');

                var modal = this;
                modal.querySelector('#renew_member_id').value = memberId;
                modal.querySelector('#member_name').value = memberName;
                modal.querySelector('#membership_type').value = currentType;
                modal.querySelector('#amount').value = currentAmount;
            });

            // Update amount based on membership type
            document.getElementById('membership_type').addEventListener('change', function () {
                var amountField = document.getElementById('amount');
                switch (this.value) {
                    case 'Monthly':
                        amountField.value = '1000';
                        break;
                    case 'Quarterly':
                        amountField.value = '2700'; // 10% discount
                        break;
                    case 'Yearly':
                        amountField.value = '10000'; // ~16% discount
                        break;
                }
            });
        });
    </script>
</body>

</html>