<?php
include 'assets/config/connect.php';
session_start();

// Pagination setup
$products_per_page = 12;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $products_per_page;

// Get total number of products
$total_products_sql = "SELECT COUNT(*) as total FROM products WHERE status = 'active'";
$total_products_result = mysqli_query($conn, $total_products_sql);
$total_products_row = mysqli_fetch_assoc($total_products_result);
$total_products = $total_products_row['total'];
$total_pages = ceil($total_products / $products_per_page);

// Fetch products with their primary images
$sql = "SELECT p.*, pi.image_path 
        FROM products p 
        LEFT JOIN product_images pi ON p.id = pi.product_id AND pi.is_primary = 1 
        WHERE p.status = 'active'
        ORDER BY p.created_at DESC 
        LIMIT $offset, $products_per_page";
$result = mysqli_query($conn, $sql);
?>

<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Gym Products</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/logo-sm.png">

    <!-- Bootstrap Css -->
    <link href="assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .product-card {
            transition: transform 0.3s, box-shadow 0.3s;
            height: 100%;
        }
        .product-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        .product-image {
            height: 200px;
            object-fit: contain;
            width: 100%;
        }
        .product-title {
            font-size: 1.1rem;
            font-weight: 600;
            height: 2.8rem;
            overflow: hidden;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
        }
        .product-description {
            height: 3.6rem;
            overflow: hidden;
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
        }
        .price-tag {
            font-size: 1.25rem;
            font-weight: bold;
            color: #28a745;
        }
        .stock-info {
            font-size: 0.9rem;
        }
        .weight-info {
            background-color: #f8f9fa;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 0.85rem;
        }
        .pagination {
            justify-content: center;
            margin-top: 30px;
        }
        .card-body {
            display: flex;
            flex-direction: column;
        }
        .card-text {
            flex-grow: 1;
        }
        .action-buttons {
            margin-top: auto;
        }
    </style>
</head>

<body data-sidebar="dark">
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'assets/config/header.php' ?>
        <?php include 'assets/config/sidebar.php' ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="page-title-box">
                                <h4>Product Catalog</h4>
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item active">Browse our gym products</li>
                                </ol>
                            </div>
                        </div>
                        <div class="col-sm-6 text-end">
                            <a href="add-product.php" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Add New Product
                            </a>
                        </div>
                    </div>
                    <!-- end page title -->

                    <!-- Display alerts -->
                    <?php if (isset($_SESSION['success'])): ?>
                        <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
                    <?php endif; ?>
                    <?php if (isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
                    <?php endif; ?>

                    <!-- Product Grid -->
                    <div class="row">
                        <?php if ($result->num_rows > 0): ?>
                            <?php while ($product = $result->fetch_assoc()): ?>
                                <div class="col-xl-3 col-lg-4 col-md-6 mb-4">
                                    <div class="card product-card">
                                        <!-- Product Image -->
                                        <?php if (!empty($product['image_path'])): ?>
                                            <img src="<?= htmlspecialchars($product['image_path']) ?>" class="card-img-top product-image" alt="<?= htmlspecialchars($product['name']) ?>">
                                        <?php else: ?>
                                            <div class="card-img-top product-image bg-light d-flex align-items-center justify-content-center">
                                                <i class="fas fa-image fa-3x text-muted"></i>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <div class="card-body">
                                            <!-- Product Name -->
                                            <h5 class="card-title product-title"><?= htmlspecialchars($product['name']) ?></h5>
                                            
                                            <!-- SKU -->
                                            <h6 class="card-subtitle mb-2 text-muted">SKU: <?= htmlspecialchars($product['sku']) ?></h6>
                                            
                                            <!-- Price -->
                                            <div class="price-tag mb-2">₹<?= number_format($product['price'], 2) ?></div>
                                            
                                            <!-- Stock Information -->
                                            <div class="stock-info mb-2">
                                                <?php if ($product['stock_quantity'] > 10): ?>
                                                    <span class="badge bg-success">In Stock (<?= $product['stock_quantity'] ?>)</span>
                                                <?php elseif ($product['stock_quantity'] > 0): ?>
                                                    <span class="badge bg-warning">Low Stock (<?= $product['stock_quantity'] ?>)</span>
                                                <?php else: ?>
                                                    <span class="badge bg-danger">Out of Stock</span>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <!-- Weight Information -->
                                            <?php if (!empty($product['weight_value'])): ?>
                                                <div class="weight-info mb-2">
                                                    Weight: <?= $product['weight_value'] ?> <?= $product['weight_unit'] ?>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <!-- Action Buttons -->
                                            <div class="action-buttons d-flex justify-content-between mt-3">
                                                <!-- <a href="view_product.php?id=<?= $product['id'] ?>" class="btn btn-sm btn-info" title="View Details">
                                                    <i class="fas fa-eye"></i>
                                                </a> -->
                                                <a href="edit_product.php?id=<?= $product['id'] ?>" class="btn btn-sm btn-primary" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <a href="#" onclick="confirmDelete(<?= $product['id'] ?>)" class="btn btn-sm btn-danger" title="Delete">
                                                    <i class="fas fa-trash-alt"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <div class="col-12 text-center py-5">
                                <i class="fas fa-box-open fa-3x text-muted mb-3"></i>
                                <h4>No products found</h4>
                                <p class="text-muted">Get started by adding your first product.</p>
                                <a href="add-product.php" class="btn btn-primary mt-2">
                                    <i class="fas fa-plus"></i> Add New Product
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Pagination -->
                    <?php if ($total_pages > 1): ?>
                    <nav aria-label="Product pagination">
                        <ul class="pagination">
                            <!-- Previous Page Link -->
                            <li class="page-item <?= $page <= 1 ? 'disabled' : '' ?>">
                                <a class="page-link" href="?page=<?= $page - 1 ?>" aria-label="Previous">
                                    <span aria-hidden="true">&laquo;</span>
                                </a>
                            </li>
                            
                            <!-- Page Number Links -->
                            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                <li class="page-item <?= $i == $page ? 'active' : '' ?>">
                                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                                </li>
                            <?php endfor; ?>
                            
                            <!-- Next Page Link -->
                            <li class="page-item <?= $page >= $total_pages ? 'disabled' : '' ?>">
                                <a class="page-link" href="?page=<?= $page + 1 ?>" aria-label="Next">
                                    <span aria-hidden="true">&raquo;</span>
                                </a>
                            </li>
                        </ul>
                    </nav>
                    <?php endif; ?>

                </div> <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-12">
                            ©
                            <script>document.write(new Date().getFullYear())</script> GymMaster <span
                                class="d-none d-sm-inline-block"> - Product Management System</span>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <!-- JAVASCRIPT -->
    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/libs/metismenu/metisMenu.min.js"></script>
    <script src="assets/libs/simplebar/simplebar.min.js"></script>
    <script src="assets/libs/node-waves/waves.min.js"></script>
    <script src="assets/libs/jquery-sparkline/jquery.sparkline.min.js"></script>
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>

    <script>
        // Delete confirmation
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = 'delete_product.php?id=' + id;
                }
            });
        }
    </script>
</body>
</html>