<?php
session_start();
include 'assets/config/connect.php';

$error = ''; // Initialize error variable


?>

<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Gym - Register Member</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/logo-sm.png">

    <!-- Bootstrap Css -->
    <link href="assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />
    <style>
        .error-message {
            color: #dc3545;
            font-size: 0.875em;
            margin-top: 0.25rem;
        }

        .is-invalid {
            border-color: #dc3545 !important;
        }
    </style>
</head>

<body data-sidebar="dark">
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'assets/config/header.php' ?>
        <?php include 'assets/config/sidebar.php' ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="page-title-box">
                                <h4> Members</h4>
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item active">Register Member</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="card-title">Register Member </h4>
                                    <p class="card-title-desc">Fill All Details Carefully
                                        <span class="badge bg-primary">Gym</span>
                                    </p>
                                    <form id="memberForm" method="POST" action="save_member.php"
                                        enctype="multipart/form-data">
                                        <div class="row">
                                            <!-- Name -->
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Full Name</label>
                                                <input type="text" class="form-control" name="name" required>
                                            </div>

                                            <!-- Phone Number -->
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Phone Number</label>
                                                <input type="text" class="form-control" name="phone" required>
                                            </div>

                                            <!-- Email -->
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Email</label>
                                                <input type="email" class="form-control" name="email" required>
                                            </div>

                                            <!-- Address -->
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Address</label>
                                                <textarea class="form-control" name="address" rows="2"
                                                    required></textarea>
                                            </div>

                                            <!-- Start Date -->
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Start Date</label>
                                                <input type="date" class="form-control" name="start_date" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
    <label class="form-label">Password</label>
    <div class="input-group">
        <input type="password" class="form-control" name="password" id="password" required>
        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword()" tabindex="-1">
            👁️
        </button>
    </div>
</div>

                                            <!-- Profile Photo (optional) -->
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Profile Photo (optional)</label>
                                                <input type="file" class="form-control" name="profile_photo"
                                                    accept="image/*">
                                            </div>

                                            <!-- Submit Button -->
                                            <div class="col-md-12 text-center mt-3">
                                                <button type="submit" class="btn btn-primary">Register Member</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div> <!-- container-fluid -->
            </div>
            <!-- End Page-content -->
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <!-- JAVASCRIPT -->
    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/libs/metismenu/metisMenu.min.js"></script>
    <script src="assets/libs/simplebar/simplebar.min.js"></script>
    <script src="assets/libs/node-waves/waves.min.js"></script>
    <script src="assets/libs/jquery-sparkline/jquery.sparkline.min.js"></script>
    <script src="assets/js/app.js"></script>
<script>
function togglePassword() {
    const passwordInput = document.getElementById('password');
    const type = passwordInput.getAttribute('type');
    passwordInput.setAttribute('type', type === 'password' ? 'text' : 'password');
}
</script>
   
</body>

</html>