<?php
include 'assets/config/connect.php';
$member_id = $_GET['id'];

// Fetch all measurements
$result = mysqli_query($conn, "SELECT * FROM measurements WHERE member_id = $member_id ORDER BY measured_on ASC");

$dates = [];
$weights = [];
$chests = [];
$biceps = [];
$waists = [];

while ($row = mysqli_fetch_assoc($result)) {
    $dates[] = date("d M", strtotime($row['measured_on']));
    $weights[] = $row['weight'];
    $chests[] = $row['chest'];
    $biceps[] = $row['biceps'];
    $waists[] = $row['waist'];
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Measurement Graph</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <h2>Measurement History with Graph</h2>

    <!-- Table View -->
    <table border='1' cellpadding='5'>
        <tr><th>Date</th><th>Weight</th><th>Chest</th><th>Biceps</th><th>Waist</th></tr>
        <?php
        mysqli_data_seek($result, 0);
        while ($row = mysqli_fetch_assoc($result)) {
            echo "<tr>
                <td>{$row['measured_on']}</td>
                <td>{$row['weight']}</td>
                <td>{$row['chest']}</td>
                <td>{$row['biceps']}</td>
                <td>{$row['waist']}</td>
            </tr>";
        }
        ?>
    </table>

    <br><h3>📈 Measurement Progress Chart</h3>
    <canvas id="measurementChart" width="600" height="300"></canvas>

    <script>
        const ctx = document.getElementById('measurementChart').getContext('2d');
        const chart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: <?= json_encode($dates) ?>,
                datasets: [
                    {
                        label: 'Weight (kg)',
                        data: <?= json_encode($weights) ?>,
                        borderColor: 'red',
                        fill: false
                    },
                    {
                        label: 'Chest (cm)',
                        data: <?= json_encode($chests) ?>,
                        borderColor: 'blue',
                        fill: false
                    },
                    {
                        label: 'Biceps (cm)',
                        data: <?= json_encode($biceps) ?>,
                        borderColor: 'green',
                        fill: false
                    },
                    {
                        label: 'Waist (cm)',
                        data: <?= json_encode($waists) ?>,
                        borderColor: 'orange',
                        fill: false
                    }
                ]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: false
                    }
                }
            }
        });
    </script>
</body>
</html>
