<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Best Gym Packages - Barbell Life – Unisex Gym</title>
    <!-- CSS Here -->
    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/x-icon">
    <link href="https://fonts.googleapis.com/css2?family=Zen+Dots&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/all.min.css">
    <link rel="stylesheet" href="assets/css/slick.css">
    <link rel="stylesheet" href="assets/css/animate_plugin.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/aos.css">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/media-query.css">
    <style>
        .container {
            max-width: 1200px;
            margin: 0 auto;
            color:#fff;
        }
        
        .header {
            text-align: center;
            margin-bottom: 40px;
            padding: 20px;
        }
        
        .title {
            font-size: 2.8rem;
            color: #ff640d;
            margin-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        
        .subtitle {
            font-size: 1.2rem;
            color: #ccc;
            max-width: 800px;
            margin: 0 auto;
        }
        
        .diet-plans {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
            gap: 30px;
            margin-bottom: 50px;
        }
        
        .client-card {
            background: linear-gradient(145deg, #1a1a1a, #252525);
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.4);
            transition: transform 0.3s ease;
        }
        
        .client-card:hover {
            transform: translateY(-5px);
        }
        
        .client-header {
            background: #ff640d;
            padding: 20px;
            text-align: center;
            position: relative;
        }
        
        .client-title {
            font-size: 1.6rem;
            margin: 0;
            color: white;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .client-subtitle {
            font-size: 1rem;
            margin: 5px 0 0;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .client-content {
            padding: 25px;
        }
        
        .meal-time {
            color: #ff640d;
            font-size: 1.2rem;
            font-weight: 600;
            margin: 20px 0 10px;
            padding-bottom: 5px;
            border-bottom: 1px solid #444;
            display: flex;
            align-items: center;
        }
        
        .meal-time:first-child {
            margin-top: 0;
        }
        
        .meal-time i {
            margin-right: 10px;
            font-size: 1.1rem;
        }
        
        .meal-items {
            background: #2a2a2a;
            border-left: 4px solid #ff640d;
            padding: 15px 20px;
            border-radius: 0 8px 8px 0;
            margin-bottom: 15px;
        }
        
        .meal-item {
            margin-bottom: 8px;
            display: flex;
            align-items: flex-start;
        }
        
        .meal-item:last-child {
            margin-bottom: 0;
        }
        
        .meal-item i {
            color: #ff640d;
            margin-right: 10px;
            margin-top: 5px;
            font-size: 0.8rem;
        }
        
        .notice-box {
            background: rgba(255, 100, 13, 0.1);
            border-left: 4px solid #ff640d;
            padding: 20px;
            border-radius: 0 8px 8px 0;
            margin-top: 25px;
        }
        
        .notice-title {
            color: #ff640d;
            font-weight: 600;
            margin-bottom: 10px;
            font-size: 1.2rem;
            display: flex;
            align-items: center;
        }
        
        .notice-title i {
            margin-right: 10px;
        }
        
        .notice-item {
            margin-bottom: 8px;
            display: flex;
            align-items: flex-start;
        }
        
        .notice-item i {
            color: #ff640d;
            margin-right: 10px;
            margin-top: 5px;
            font-size: 0.8rem;
        }
        
        @media (max-width: 768px) {
            .diet-plans {
                grid-template-columns: 1fr;
            }
            
            .title {
                font-size: 2.2rem;
            }
        }
        
        @media (max-width: 600px) {
            .client-card {
                min-width: 100%;
            }
            
            .title {
                font-size: 1.8rem;
            }
            
            .client-header {
                padding: 15px;
            }
            
            .client-title {
                font-size: 1.4rem;
            }
            
            .client-content {
                padding: 20px;
            }
        }
    </style>
</head>

<body>
    <!-- Preloader Start -->
    <div class="preloader">
        <div class="preloader-content">
            <div class="preloader_img_circle"></div>
            <div class="preloader_img">
                <img src="assets/images/preloader/fitness_preimg.gif" alt="fitness_preimg">
            </div>
        </div>
    </div>
    <!-- Preloader end -->

    <div class="site_content">
        <!-- Header Start -->
        <?php include 'assets/config/header.php' ?>
        <!-- Header end -->

        <!-- Common Page Banner Start -->
        <section class="commom_banner_sec" id="commom_banner_sec">
            <div class="common_banner_bg common_banner_ourpricingplanpage_bg">
                <div class="container">
                    <div class="common_banner_content text-lg-start text-center">
                        <h1 class="d-none">hidden</h1>
                        <h2 class="d-none">hidden</h2>
                        <h3 class="d-none">hidden</h3>
                        <h4 class="d-none">hidden</h4>
                        <h5 class="satoshi_fontfamily line_height_normal fw_500 color_white" data-aos="fade-down">
                            <a href="index" class="color_white">Home</a> / <span class="color_orange">Client Diet Plans
                                1</span>
                        </h5>
                        <h2 class="color_white line_height_normal pt-20" data-aos="fade-down">Client Diet Plans</h2>
                        <h3 class="d-none">hidden</h3>
                        <h4 class="d-none">hidden</h4>
                    </div>
                </div>
            </div>
        </section>
        <!-- Common Page Banner end -->

       
        <!-- Pricing-Plans End -->
 <section class="diet-section" id="weightLossDiet">
      <div class="container">
        <div class="header">
            <h1 class="title">Client Diet Plans</h1>
            <p class="subtitle">Personalized nutrition plans designed by Barbell Life Fitness Unisex Gym experts</p>
        </div>
        
        <div class="diet-plans">
            <!-- Client 1 - Ganesh -->
            <div class="client-card">
                <div class="client-header">
                    <h3 class="client-title">Client - Ganesh</h3>
                    <p class="client-subtitle">Muscle Building Non-Veg Diet Plan</p>
                </div>
                <div class="client-content">
                    <div class="meal-time">
                        <i class="fas fa-sun"></i> Morning
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Lukewarm Water</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-clock"></i> After 30 min
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Dry fruits + Oats + Protein + 1 Apple</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-egg"></i> Breakfast
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>1 Sandwich, 5 Eggs white + Green tea</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-utensils"></i> Lunch
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Dal + Rice + 2 Chapatis + Green Veggies or Paneer or Chicken Breast or Egg bhurjiya or fish or Boil Chickpeas (Chole no oil normal) with full plate salad</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-dumbbell"></i> Before Gym
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>2 Boil Potatoes with Curd</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-dumbbell"></i> After Gym (within 15 mins)
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Protein + 5 Eggs white</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-moon"></i> Dinner
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>350 gram Chicken Breast or Soya or Beans Boil or Rajma boil or Fish or Paneer with 1/2 Bowl Rice is Enough</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-bed"></i> During Sleep
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>1 Glass Cow milk without fat + 1 Tab Ashwagandha (Patanjali)</span>
                        </div>
                    </div>
                    
                    <div class="notice-box">
                        <h4 class="notice-title"><i class="fas fa-exclamation-circle"></i> Important Notice</h4>
                        <div class="notice-item">
                            <i class="fas fa-check-circle"></i>
                            <span>4 to 5 liter Water Daily</span>
                        </div>
                        <div class="notice-item">
                            <i class="fas fa-check-circle"></i>
                            <span>10 Eggs white Daily</span>
                        </div>
                        <div class="notice-item">
                            <i class="fas fa-check-circle"></i>
                            <span>400 gram Chicken Breast Daily or other veg protein source</span>
                        </div>
                        <div class="notice-item">
                            <i class="fas fa-check-circle"></i>
                            <span>1 Tab Multi + 1 Tab Omega + 1 Tab Ashwagandha</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Client 2 - Manasvi -->
            <div class="client-card">
                <div class="client-header">
                    <h3 class="client-title">Client - Manasvi</h3>
                    <p class="client-subtitle">Weight Management Diet Plan</p>
                </div>
                <div class="client-content">
                    <div class="meal-time">
                        <i class="fas fa-sun"></i> Morning Wakeup
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Apple Cider 1 Glass or 1 Apple</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-egg"></i> Breakfast
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Sprouts + Moong Chilla or Steam poha with Papaya and Green tea with a pinch of Cinnamon powder and 1 Spoon of Soaked Chia seeds</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-utensils"></i> Lunch
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Dal + 1/2 Bowl Rice + Salad full plate + Steam or Stir fry Green veggies</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-dumbbell"></i> Before Gym
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>1 Apple</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-dumbbell"></i> After Gym
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Boil Channa or Roasted Channa</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-clock"></i> Evening
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Roasted Makhana + 1 Green-tea</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-moon"></i> Dinner
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Full Bowl of Salad like Bean Salad, Rajma Salad or Tofu Salad or Paneer Salad etc</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-bed"></i> During Sleep
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Fat-free Cow milk for Calcium fulfill</span>
                        </div>
                    </div>
                    
                    <div class="notice-box">
                        <h4 class="notice-title"><i class="fas fa-exclamation-circle"></i> Important Notice</h4>
                        <div class="notice-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Drink 4 to 5 liter water daily</span>
                        </div>
                        <div class="notice-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Double of your Body weight protein consume in grams</span>
                        </div>
                        <div class="notice-item">
                            <i class="fas fa-check-circle"></i>
                            <span>2 Time Green tea</span>
                        </div>
                        <div class="notice-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Totally Avoid Sugar or oily things</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </section>
       

        <!-- Get-Touch Start -->
      
        <!-- Get-Touch End -->



        <!-- Gym-Marqueer-Text Start -->
        <?php include 'assets/config/slider.php'; ?>
        <!-- Gym-Marqueer-Text End -->

        <!-- footer Start -->
        <?php include 'assets/config/footer.php'; ?>
        <!-- footer End -->

        <!-- Scroll-Top Start -->
        <div class="scrolltop_area orangeglow">
            <button id="scroll-top-btn">
                <span class="scroll-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <mask style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="24" height="24">
                            <path d="M0 0H24V24H0V0Z" fill="white" />
                        </mask>
                        <g>
                            <path d="M7 11L12 6L17 11" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path d="M7 17L12 12L17 17" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                        </g>
                    </svg>
                </span>
                <span id="scroll-percentage"></span>
            </button>
        </div>
        <!-- Scroll-Top End -->

        <!-- custome mouse -->
        <div class="megic-cursor">
            <div class="megic-cursor-item"></div>
        </div>
    </div>

    <!-- JS Here -->
    <script src="assets/js/jquery-3.7.1.js"></script>
    <script src="assets/js/myplugin.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/slick-animation.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script src="assets/js/plugins.js"></script>
    <script src="assets/js/TweenMax.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/allsliders.js"></script>
    <script src="assets/js/custome-cursor.js"></script>
    <script src="assets/js/style.js"></script>

    <!-- AOS Animation -->
    <script>
        AOS.init({
            duration: 1600,
        });
        AOS.init();
    </script>
</body>


</html>