<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Best Gym Packages - Barbell Life – Unisex Gym</title>
    <!-- CSS Here -->
    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/x-icon">
    <link href="https://fonts.googleapis.com/css2?family=Zen+Dots&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/all.min.css">
    <link rel="stylesheet" href="assets/css/slick.css">
    <link rel="stylesheet" href="assets/css/animate_plugin.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/aos.css">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/media-query.css">
    <style>
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        /* Diet Section Styles */
        .diet-section {
            padding: 80px 0;
            background: linear-gradient(to bottom, #1a1a1a 0%, #2c2c2c 100%);
            color: white;
            position: relative;
            overflow: hidden;
        }
        
        .diet-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: #ff640d;
        }
        
        .section-header {
            text-align: center;
            margin-bottom: 60px;
        }
        
        .section-title {
            font-size: 2.8rem;
            margin-bottom: 15px;
            color: white;
            position: relative;
            display: inline-block;
        }
        
        .section-title::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: #ff640d;
        }
        
        .section-subtitle {
            font-size: 1.2rem;
            color: #ccc;
            max-width: 700px;
            margin: 0 auto;
        }
        
        .diet-plan {
            background: #252525;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            margin-bottom: 40px;
        }
        
        .diet-header {
            background: #ff640d;
            padding: 20px 30px;
            text-align: center;
        }
        
        .diet-title {
            font-size: 1.8rem;
            margin: 0;
            color: white;
        }
        
        .diet-subtitle {
            font-size: 1rem;
            margin: 5px 0 0;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .diet-content {
            padding: 30px;
        }
        
        .meal-time {
            color: #ff640d;
            font-size: 1.3rem;
            font-weight: 600;
            margin: 25px 0 10px;
            padding-bottom: 5px;
            border-bottom: 1px solid #444;
            display: flex;
            align-items: center;
        }
        
        .meal-time:first-child {
            margin-top: 0;
        }
        
        .meal-time i {
            margin-right: 10px;
            font-size: 1.2rem;
        }
        
        .meal-items {
            background: #2e2e2e;
            border-left: 4px solid #ff640d;
            padding: 15px 20px;
            border-radius: 0 8px 8px 0;
            margin-bottom: 15px;
        }
        
        .meal-item {
            margin-bottom: 8px;
            display: flex;
            align-items: flex-start;
        }
        
        .meal-item:last-child {
            margin-bottom: 0;
        }
        
        .meal-item i {
            color: #ff640d;
            margin-right: 10px;
            margin-top: 5px;
            font-size: 0.8rem;
        }
        
        .note-box {
            background: rgba(255, 100, 13, 0.1);
            border-left: 4px solid #ff640d;
            padding: 20px;
            border-radius: 0 8px 8px 0;
            margin-top: 30px;
        }
        
        .note-title {
            color: #ff640d;
            font-weight: 600;
            margin-bottom: 10px;
            font-size: 1.2rem;
        }
        
        /* Responsive Styles */
        @media (max-width: 768px) {
            .section-title {
                font-size: 2.2rem;
            }
            
            .diet-content {
                padding: 20px;
            }
            
            .meal-time {
                font-size: 1.1rem;
            }
        }
        
        @media (max-width: 480px) {
            .section-title {
                font-size: 1.8rem;
            }
            
            .diet-header {
                padding: 15px 20px;
            }
            
            .diet-title {
                font-size: 1.5rem;
            }
        }
    </style>
</head>

<body>
    <!-- Preloader Start -->
    <div class="preloader">
        <div class="preloader-content">
            <div class="preloader_img_circle"></div>
            <div class="preloader_img">
                <img src="assets/images/preloader/fitness_preimg.gif" alt="fitness_preimg">
            </div>
        </div>
    </div>
    <!-- Preloader end -->

    <div class="site_content">
        <!-- Header Start -->
        <?php include 'assets/config/header.php' ?>
        <!-- Header end -->

        <!-- Common Page Banner Start -->
        <section class="commom_banner_sec" id="commom_banner_sec">
            <div class="common_banner_bg common_banner_ourpricingplanpage_bg">
                <div class="container">
                    <div class="common_banner_content text-lg-start text-center">
                        <h1 class="d-none">hidden</h1>
                        <h2 class="d-none">hidden</h2>
                        <h3 class="d-none">hidden</h3>
                        <h4 class="d-none">hidden</h4>
                        <h5 class="satoshi_fontfamily line_height_normal fw_500 color_white" data-aos="fade-down">
                            <a href="index" class="color_white">Home</a> / <span class="color_orange">WEIGHT LOSS DIET 
                                1</span>
                        </h5>
                        <h2 class="color_white line_height_normal pt-20" data-aos="fade-down">WEIGHT LOSS DIET </h2>
                        <h3 class="d-none">hidden</h3>
                        <h4 class="d-none">hidden</h4>
                    </div>
                </div>
            </div>
        </section>
        <!-- Common Page Banner end -->

       
        <!-- Pricing-Plans End -->
 <section class="diet-section" id="weightLossDiet">
        <div class="container">
            <div class="section-header">
                <h2 class="section-title">WEIGHT LOSS DIET – EGGITARIAN</h2>
                <p class="section-subtitle">Professional nutrition plan designed by Barbell Life Fitness Unisex Gym experts</p>
            </div>
            
            <div class="diet-plan">
                <div class="diet-header">
                    <h3 class="diet-title">Daily Meal Plan</h3>
                    <p class="diet-subtitle">Follow this schedule for optimal results</p>
                </div>
                
                <div class="diet-content">
                    <div class="meal-time">
                        <i class="fas fa-sun"></i> 6 AM - Morning Wakeup
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>300 ml warm water + L-carnitine</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-egg"></i> 7 AM - Breakfast
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Green Tea + 100 gm oats + Dry fruits (Walnut/Almond) + Chilla/Poha/Upma</span>
                        </div>
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Multi + Omega + Papaya + 4 egg white + Green Tea</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-utensils"></i> 12 Noon - Lunch
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Dal + Half Bowl Rice + Chapatti + Green veggies</span>
                        </div>
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Egg white scramble or 50 gm Paneer bhurjiya + Curd + 1 full plate Salad</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-apple-alt"></i> 4 PM - Snack
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>100 gm Roasted Makhana + Green Tea + 1 scoop Chia Seeds</span>
                        </div>
                    </div>
                    
                    <div class="meal-time">
                        <i class="fas fa-moon"></i> 9 PM - Dinner
                    </div>
                    <div class="meal-items">
                        <div class="meal-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Egg Salad / White Salad + Beans Salad + Paneer Salad / Tofu Salad</span>
                        </div>
                    </div>
                    
                    <div class="note-box">
                        <h4 class="note-title">Important Notes:</h4>
                        <p>• Drink at least 3-4 liters of water throughout the day</p>
                        <p>• Maintain a consistent sleep schedule of 7-8 hours</p>
                        <p>• Combine this diet with regular exercise for best results</p>
                        <p>• Consult with our nutritionists for personalized adjustments</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
       

        <!-- Get-Touch Start -->
      
        <!-- Get-Touch End -->



        <!-- Gym-Marqueer-Text Start -->
        <?php include 'assets/config/slider.php'; ?>
        <!-- Gym-Marqueer-Text End -->

        <!-- footer Start -->
        <?php include 'assets/config/footer.php'; ?>
        <!-- footer End -->

        <!-- Scroll-Top Start -->
        <div class="scrolltop_area orangeglow">
            <button id="scroll-top-btn">
                <span class="scroll-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <mask style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="24" height="24">
                            <path d="M0 0H24V24H0V0Z" fill="white" />
                        </mask>
                        <g>
                            <path d="M7 11L12 6L17 11" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path d="M7 17L12 12L17 17" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                        </g>
                    </svg>
                </span>
                <span id="scroll-percentage"></span>
            </button>
        </div>
        <!-- Scroll-Top End -->

        <!-- custome mouse -->
        <div class="megic-cursor">
            <div class="megic-cursor-item"></div>
        </div>
    </div>

    <!-- JS Here -->
    <script src="assets/js/jquery-3.7.1.js"></script>
    <script src="assets/js/myplugin.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/slick-animation.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script src="assets/js/plugins.js"></script>
    <script src="assets/js/TweenMax.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/allsliders.js"></script>
    <script src="assets/js/custome-cursor.js"></script>
    <script src="assets/js/style.js"></script>

    <!-- AOS Animation -->
    <script>
        AOS.init({
            duration: 1600,
        });
        AOS.init();
    </script>
</body>


</html>