<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Best Gym in Unnao - Barbell Life – Unisex Gym</title>
    <!-- CSS Here -->
    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/x-icon">
    <link href="https://fonts.googleapis.com/css2?family=Zen+Dots&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/all.min.css">
    <link rel="stylesheet" href="assets/css/slick.css">
    <link rel="stylesheet" href="assets/css/animate_plugin.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/aos.css">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/media-query.css">
</head>

<body>
    <!-- Preloader Start -->
    <div class="preloader">
        <div class="preloader-content">
            <div class="preloader_img_circle"></div>
            <div class="preloader_img">
                <img src="assets/images/preloader/fitness_preimg.gif" alt="fitness_preimg">
            </div>
        </div>
    </div>
    <!-- Preloader end -->
    <div class="site_content">
        <!-- Header Start -->
        <?php include 'assets/config/header.php'; ?>
        <!-- Header end -->

        <!-- Banner-Slider Start -->
        <section id="hero_sec">
            <div class="home_banner_slider" id="home_banner_1">
                <div class="banner_slider_list lazy">
                    <!-- First Slide -->
                    <div class="banner_slider_item">
                        <div class="banner_slider_img slide slide_one" data-animation-in="shine_1" data-delay-in="0.2">
                            <div class="container">
                                <div class="banner_slider_content">
                                    <h1 class="d-none">hidden</h1>
                                    <h2 class="d-none">hidden</h2>
                                    <h3 class="d-none">hidden</h3>
                                    <h4 class="d-none">hidden</h4>
                                    <h5 class="line_height_normal fw_500 color_white satoshi_fontfamily"
                                        data-animation-in="fadeInRight" data-delay-in="0.2">
                                        Welcome to Barbell Life
                                    </h5>
                                    <h1 data-animation-in="fadeInRight" data-delay-in="0.2">
                                        A UNISEX GYM FOR EVERYONE
                                    </h1>
                                    <h2 class="d-none">hidden</h2>
                                    <h3 class="d-none">hidden</h3>
                                    <h4 class="d-none">hidden</h4>
                                    <div class="slider_button" data-animation-in="fadeInRight" data-delay-in="0.2">
                                        <div class="banner_btn">
                                            <a href="contact-us" class="orange_btn">
                                                <span class="orenge_text orangeglow_btn" data-hover="Join Now">
                                                    Join Now
                                                </span>
                                                <span class="orenge_icon whiteglow_btn">
                                                    <img src="assets/images/svgs/common_button_arrow.svg"
                                                        alt="common_button_arrow">
                                                </span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Second Slide -->
                    <div class="banner_slider_item">
                        <div class="banner_slider_img slide slide_two" data-animation-in="shine_1" data-delay-in="0.2">
                            <div class="shine"></div>
                            <div class="container">
                                <div class="banner_slider_content">
                                    <h5 class="line_height_normal fw_500 color_white satoshi_fontfamily"
                                        data-animation-in="fadeInRight" data-delay-in="0.2">
                                        BUILD STRENGTH • BOOST CONFIDENCE
                                    </h5>
                                    <h1 data-animation-in="fadeInRight" data-delay-in="0.2">
                                        BARBELL LIFE – UNISEX FITNESS JOURNEY
                                    </h1>
                                    <h2 class="d-none">hidden</h2>
                                    <h3 class="d-none">hidden</h3>
                                    <h4 class="d-none">hidden</h4>
                                    <h5 class="d-none">hidden</h5>
                                    <div class="slider_button" data-animation-in="fadeInRight" data-delay-in="0.2">
                                        <div class="banner_btn">
                                            <a href="contact-us" class="orange_btn">
                                                <span class="orenge_text orangeglow_btn" data-hover="Get Started">
                                                    Get Started
                                                </span>
                                                <span class="orenge_icon whiteglow_btn">
                                                    <img src="assets/images/svgs/common_button_arrow.svg"
                                                        alt="common_button_arrow">
                                                </span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Quick Contact -->
                <div class="quick_contact">
                    <a href="tel:+918299808887" class="color_white custom_cursor_orangeglow">
                        <span>
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <mask style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="24"
                                    height="24">
                                    <path d="M0 0H24V24H0V0Z" fill="white" />
                                </mask>
                                <g>
                                    <path
                                        d="M5 4H9L11 9L8.5 10.5C9.57096 12.6715 11.3285 14.429 13.5 15.5L15 13L20 15V19C20 19.5304 19.7893 20.0391 19.4142 20.4142C19.0391 20.7893 18.5304 21 18 21C14.0993 20.763 10.4202 19.1065 7.65683 16.3432C4.8935 13.5798 3.23705 9.90074 3 6C3 5.46957 3.21071 4.96086 3.58579 4.58579C3.96086 4.21071 4.46957 4 5 4Z"
                                        stroke="white" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path
                                        d="M15 7C15.5304 7 16.0391 7.21071 16.4142 7.58579C16.7893 7.96086 17 8.46957 17 9"
                                        stroke="white" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path
                                        d="M15 3C16.5913 3 18.1174 3.63214 19.2426 4.75736C20.3679 5.88258 21 7.4087 21 9"
                                        stroke="white" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </g>
                            </svg>
                        </span>
                        <h6 class="line_height_24 fw_500 satoshi_fontfamily color_white">
                            +91 8299808887
                        </h6>
                    </a>
                </div>
            </div>
        </section>

        <!-- Banner-Slider End -->
        <section class="about_sec">
            <div class="container">
                <div class="about_us_page sec_padding">
                    <div class="row align-items-end">
                        <!-- Left Side Images -->
                        <div class="col-lg-6">
                            <div class="about_page_img_area">
                                <div class="about_big_img about_img_shap_1 reveal">
                                    <img src="assets/images/common_img/aboutpage_img_1.png" alt="about_img">
                                </div>
                                <div class="about_img_inner about_img_shap_2 reveal">
                                    <img src="assets/images/common_img/aboutpage_img_2.png" alt="about_img">
                                </div>
                            </div>
                        </div>

                        <!-- Right Side Content -->
                        <div class="col-lg-6">
                            <div class="about_detail_area">
                                <div class="common_title_area about_us_title text-start">
                                    <h5 class="satoshi_fontfamily fw_500 line_height_normal color_orange"
                                        data-aos="fade-down">Know About Us</h5>
                                    <h3 class="pt-10 reveal custom_lightSpeedInLeft">WELCOME TO BARBELL LIFE</h3>
                                    <h4 class="d-none">hidden</h4>
                                    <h5 class="d-none">hidden</h5>
                                </div>
                                <div class="about_page_detail_area">
                                    <p class="satoshi_fontfamily fw_500 line_height_30 color_lightblack"
                                        data-aos="fade-down">
                                        Barbell Life is a modern unisex gym focused on strength, endurance, and overall
                                        fitness.
                                        We provide state-of-the-art equipment, expert trainers, and specialized programs
                                        for beginners, athletes, and professionals.
                                        Our mission is to create a motivating environment where everyone can achieve
                                        their fitness journey — from weight loss to competition-level powerlifting.
                                    </p>
                                    <ul class="satoshi_fontfamily fw_500 m-0">
                                        <li class="reveal custom_lightSpeedInLeft">Cutting-edge gym equipment for
                                            strength, endurance, and mobility training.</li>
                                        <li class="reveal custom_lightSpeedInLeft">Certified trainers dedicated to
                                            personalized coaching and guidance.</li>
                                        <li class="reveal custom_lightSpeedInLeft">Specialized programs for beginners,
                                            athletes, and professionals.</li>
                                        <li class="reveal custom_lightSpeedInLeft">Supportive fitness community
                                            fostering motivation and results.</li>
                                    </ul>
                                    <div class="about_us_btn reveal custom_fade_buttom mt-60">
                                        <a href="class-timetable" class="orange_btn black_btn">
                                            <span class="orenge_text whiteglow_btn" data-hover="Explore Programs">
                                                Explore Programs
                                            </span>
                                            <span class="orenge_icon whiteglow_btn">
                                                <img src="assets/images/svgs/common_button_arrow.svg"
                                                    alt="common_button_arrow">
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End Right Side -->
                    </div>
                </div>
            </div>
        </section>

        <!-- We-Offer Start -->
        <section class="what_we_offer_sec">
            <div class="container">
                <div class="what_we_offer sec_padding">
                    <div class="row">
                        <div class="col-12">
                            <div class="common_title_area we_offer_title text-center">
                                <h5 class="satoshi_fontfamily fw_500 line_height_normal color_orange"
                                    data-aos="fade-down">What We Offer</h5>
                                <h3 class="pt-10 reveal custom_lightSpeedInLeft">THE BEST STANDARDS ANYWHERE</h3>
                                <h4 class="d-none">hidden</h4>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="we_offer_area pt-60">
                                <div class="row">
                                    <div class="col-xl-3 col-lg-4 col-sm-6">
                                        <div class="we_offer_box reveal custom_zoom_in">
                                            <div class="we_offer_icon">
                                                <img src="assets/images/icons/trainer.png" alt="Skilled Trainers"
                                                    width="100" height="100">
                                            </div>
                                            <div class="we_offer_info">
                                                <h5 class="satoshi_fontfamily_bold">Skilled Trainers</h5>
                                                <p class="satoshi_fontfamily fw_500 line_height_30 color_lightblack">Our
                                                    certified trainers provide personalized guidance to help you achieve
                                                    your fitness goals effectively.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-4 col-sm-6">
                                        <div class="we_offer_box reveal custom_zoom_in">
                                            <div class="we_offer_icon">
                                                <img src="assets/images/icons/fitness.png" alt="Quality Equipment"
                                                    width="100" height="100">
                                            </div>
                                            <div class="we_offer_info">
                                                <h5 class="satoshi_fontfamily_bold">Quality Equipment</h5>
                                                <p class="satoshi_fontfamily fw_500 line_height_30 color_lightblack">
                                                    Train with the latest fitness equipment maintained to the highest
                                                    standards for optimal performance.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6 d-xl-block d-lg-none d-block">
                                        <div class="we_offer_box reveal custom_zoom_in">
                                            <div class="we_offer_icon">
                                                <img src="assets/images/icons/shower.png" alt="Locker Facilities"
                                                    width="100" height="100">
                                            </div>
                                            <div class="we_offer_info">
                                                <h5 class="satoshi_fontfamily_bold">Locker Facilities</h5>
                                                <p class="satoshi_fontfamily fw_500 line_height_30 color_lightblack">
                                                    Secure locker facilities to keep your belongings safe while you
                                                    focus on your workout.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-4 col-sm-6">
                                        <div class="we_offer_box reveal custom_zoom_in">
                                            <div class="we_offer_icon">
                                                <img src="assets/images/icons/protein.png" alt="Nutrition Guidance"
                                                    width="100" height="100">
                                            </div>
                                            <div class="we_offer_info">
                                                <h5 class="satoshi_fontfamily_bold">Nutrition Guidance</h5>
                                                <p class="satoshi_fontfamily fw_500 line_height_30 color_lightblack">
                                                    Expert nutritional advice to complement your training and maximize
                                                    your results.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- We-Offer End -->

        <!-- Our-Program Start -->
        <section class="our_program_sec">
            <div class="container-fluid p-0">
                <div id="program_v1">
                    <div class="our_progeam_area">
                        <div class="row m-0">
                            <!-- Group Training -->
                            <div class="col-xxl-4 col-md-6 p-0">
                                <div class="program_v1_box" data-aos="fade-up" data-aos-offset="50"
                                    data-aos-easing="ease-in-sine" data-aos-delay="100">
                                    <div class="program_v1_img h-100">
                                        <img src="assets/images/common_img/group_trining_img.png" alt="program_img"
                                            class="h-100 w-100">
                                        <a href="contact-us" class="program_v1_btn color_white">
                                            <h4 class="program_title line_height_normal color_white">GROUP TRAINING</h4>
                                            <svg width="30" height="30" viewBox="0 0 30 30" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <mask style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0"
                                                    width="30" height="30">
                                                    <path d="M0 0H30V30H0V0Z" fill="white" />
                                                </mask>
                                                <g>
                                                    <path d="M21.25 8.75L8.75 21.25" stroke="#FF640D" stroke-width="2"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                    <path d="M10 8.75H21.25V20" stroke="#FF640D" stroke-width="2"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                </g>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <!-- Personal Training -->
                            <div class="col-xxl-4 col-md-6 p-0">
                                <div class="program_v1_box" data-aos="fade-down" data-aos-offset="50"
                                    data-aos-easing="ease-in-sine" data-aos-delay="150">
                                    <div class="program_v1_img h-100">
                                        <img src="assets/images/common_img/presonal_trining_img.png" alt="program_img"
                                            class="h-100 w-100">
                                        <a href="contact-us" class="program_v1_btn color_white">
                                            <h4 class="program_title line_height_normal color_white">PERSONAL TRAINING
                                            </h4>
                                            <svg width="30" height="30" viewBox="0 0 30 30" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <mask style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0"
                                                    width="30" height="30">
                                                    <path d="M0 0H30V30H0V0Z" fill="white" />
                                                </mask>
                                                <g>
                                                    <path d="M21.25 8.75L8.75 21.25" stroke="#FF640D" stroke-width="2"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                    <path d="M10 8.75H21.25V20" stroke="#FF640D" stroke-width="2"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                </g>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <!-- Program Description -->
                            <div class="col-xxl-4 col-xl-12 p-0">
                                <div class="program_v1_box text-md-start text-center" data-aos="fade-up"
                                    data-aos-offset="50" data-aos-easing="ease-in-sine" data-aos-delay="200">
                                    <div class="program_v1_detailcard p-60 bg_black">
                                        <h4 class="color_white line_height_48" data-aos="fade-up"
                                            data-aos-anchor-placement="top-bottom">
                                            TRANSFORM YOUR FITNESS WITH BARBELL LIFE.
                                        </h4>
                                        <div class="program_v1_detailcard_info">
                                            <p class="color_white line_height_30 satoshi_fontfamily fw_500"
                                                data-aos="fade-up" data-aos-anchor-placement="top-bottom">
                                                At <strong>Barbell Life – Unisex Gym</strong>, we design training
                                                programs
                                                that help you achieve real results. Whether you thrive in the energy of
                                                <em>group workouts</em> or prefer the focus of <em>one-on-one personal
                                                    training</em>,
                                                our certified trainers are here to guide you.
                                            </p>
                                            <p class="color_white line_height_30 satoshi_fontfamily fw_500"
                                                data-aos="fade-up" data-aos-anchor-placement="top-bottom">
                                                Build strength, improve endurance, and boost your confidence in a
                                                supportive fitness community. Start your journey today and let
                                                Barbell Life help you unlock your full potential.
                                            </p>
                                        </div>
                                        <div class="program_v1_btn" data-aos="fade-up"
                                            data-aos-anchor-placement="top-bottom">
                                            <a href="contact-us" class="orange_btn">
                                                <span class="orenge_text orangeglow_btn" data-hover="Join Now">
                                                    Join Now
                                                </span>
                                                <span class="orenge_icon whiteglow_btn">
                                                    <img src="assets/images/svgs/common_button_arrow.svg"
                                                        alt="common_button_arrow">
                                                </span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End Program Description -->
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Our-Program End -->

        <!-- Our-Progress Start -->
        <section class="our_progress_sec">
            <div class="container">
                <div class="our_progress sec_padding">
                    <div class="row">
                        <div class="col-12">
                            <div class="common_title_area our_progress_title text-center">
                                <h5 class="satoshi_fontfamily fw_500 line_height_normal color_orange"
                                    data-aos="fade-down">Our Process</h5>
                                <h4 class="d-none">hidden</h4>
                                <h3 class="pt-10 pb-20 reveal custom_lightSpeedInLeft">
                                    YOUR FITNESS JOURNEY WITH BARBELL LIFE
                                </h3>
                                <h4 class="d-none">hidden</h4>
                                <p class="satoshi_fontfamily line_height_30 fw_500 color_lightblack" data-aos="fade-up">
                                    Every transformation begins with a plan. At <strong>Barbell Life – Unisex
                                        Gym</strong>,
                                    we guide you step by step — from motivation to training and achieving lasting
                                    results.
                                    Join us and take the first step toward your best self.
                                </p>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="our_progress_area pt-60">
                                <div class="row">
                                    <!-- Step 1 -->
                                    <div class="col-lg-4">
                                        <div class="our_progress_box text-center">
                                            <div class="progress_img position-relative" data-aos="zoom-in"
                                                data-aos-offset="100" data-aos-easing="ease-in-sine"
                                                data-aos-delay="100">
                                                <img src="assets/images/common_img/process_img_1.png" alt="progress_img"
                                                    class="progress_img_pera">
                                            </div>
                                            <div class="progress_step_info overflow-hidden">
                                                <h5 data-aos="fade-down">MOTIVATE</h5>
                                                <p class="satoshi_fontfamily fw_500 line_height_30 color_lightblack"
                                                    data-aos="fade-up">
                                                    We inspire you to push beyond limits with expert guidance,
                                                    supportive coaches, and a community that keeps you accountable.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Step 2 -->
                                    <div class="col-lg-4">
                                        <div class="our_progress_box text-center">
                                            <div class="progress_img position-relative" data-aos="zoom-in"
                                                data-aos-offset="100" data-aos-easing="ease-in-sine"
                                                data-aos-delay="300">
                                                <img src="assets/images/common_img/process_img_2.png" alt="progress_img"
                                                    class="progress_img_pera">
                                            </div>
                                            <div class="progress_step_info overflow-hidden">
                                                <h5 data-aos="fade-down">TRAIN</h5>
                                                <p class="satoshi_fontfamily fw_500 line_height_30 color_lightblack"
                                                    data-aos="fade-up">
                                                    From strength training to cardio, we create personalized
                                                    workout programs tailored to your fitness level and goals.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Step 3 -->
                                    <div class="col-lg-4">
                                        <div class="our_progress_box text-center">
                                            <div class="progress_img position-relative" data-aos="zoom-in"
                                                data-aos-offset="100" data-aos-easing="ease-in-sine"
                                                data-aos-delay="500">
                                                <img src="assets/images/common_img/process_img_3.png" alt="progress_img"
                                                    class="progress_img_pera">
                                            </div>
                                            <div class="progress_step_info overflow-hidden">
                                                <h5 data-aos="fade-down">ACHIEVE</h5>
                                                <p class="satoshi_fontfamily fw_500 line_height_30 color_lightblack"
                                                    data-aos="fade-up">
                                                    See measurable progress in strength, endurance, and confidence.
                                                    We help you sustain results for a healthier lifestyle.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End Steps -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Our-Progress End -->

        <!-- Traning-Video Start -->
        <div class="traning_video_sec">
            <div class="container-fluid p-0">
                <div class="row m-0">
                    <div class="col-12 p-0">
                        <div class="traning_videoplayer" data-aos="fade-zoom-in" data-aos-easing="ease-in-back"
                            data-aos-offset="0">
                            <a href="javascript:void(0);"
                                data-url="https://www.youtube.com/embed/bVce0qSREK8?rel=0&amp;showinfo=0&amp;autoplay=1"
                                class="js-overlay-start start">
                                <span class="video_text_area orangeglow_btn">
                                    <svg width="160" height="160" viewBox="0 0 160 160" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <circle cx="35" cy="21" r="3" fill="#FF640D" />
                                        <circle cx="153" cy="71" r="3" fill="#FF640D" />
                                        <circle cx="51" cy="148" r="3" fill="#FF640D" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M80.8187 0.307129L74.8335 11.7697L77.6991 11.9357L78.9631 9.5149L85.6659 9.90309L86.6416 12.4536L89.5072 12.6195L84.8865 0.542712L80.8187 0.307129ZM84.8347 7.70782L80.0423 7.43027L82.6263 2.47636L82.8404 2.48876L84.8347 7.70782ZM61.6695 14.3507L59.6371 2.73756L62.237 2.28298L63.8999 11.7846L72.3984 10.2987L72.768 12.4102L61.6695 14.3507ZM40.9965 10.1121L45.6722 20.9356L48.0954 19.8898L46.3755 15.9085L53.0241 13.0391C54.1448 12.5554 54.8911 11.898 55.2628 11.0671C55.6447 10.2318 55.5871 9.23886 55.0901 8.08839C54.5931 6.93791 53.9095 6.21519 53.0394 5.92022C52.1794 5.62089 51.189 5.71307 50.0683 6.19676L40.9965 10.1121ZM44.2698 11.0342L50.6307 8.28887C51.0749 8.09714 51.4611 8.06217 51.7892 8.18396C52.1231 8.29131 52.4056 8.61242 52.6366 9.14729C52.8633 9.67206 52.9035 10.0978 52.7571 10.4244C52.6208 10.7466 52.3305 11.0036 51.8862 11.1953L45.5189 13.9255L44.2698 11.0342ZM22.4105 43.1732L12.5031 36.6414L14.1923 34.6143L21.4317 39.3754L21.5934 35.2396L16.9162 31.3456L18.6055 29.3185L23.2953 33.2231L27.3019 32.3313L21.3189 26.0624L23.0081 24.0353L31.2263 32.5943L29.8116 34.292L23.921 35.4608L23.8252 41.4755L22.4105 43.1732ZM13.4374 59.3114C14.8189 58.6586 15.9331 57.3716 16.7802 55.4503L18.0574 52.5533C18.9133 50.6119 19.1162 48.9114 18.666 47.4518C18.2058 45.9878 17.07 44.8568 15.2585 44.0589C13.4571 43.2654 11.8657 43.1951 10.4842 43.8479C9.09269 44.4963 7.95788 45.8164 7.07979 47.8081L5.88239 50.524C5.00429 52.5157 4.79535 54.2436 5.25556 55.7076C5.7057 57.1672 6.83148 58.2937 8.6329 59.0872C10.4444 59.8851 12.0459 59.9598 13.4374 59.3114ZM7.37098 54.0987C7.24339 53.2978 7.42573 52.339 7.91799 51.2224L8.96905 48.8384C9.46131 47.7219 10.0462 46.9404 10.7237 46.4941C11.4012 46.0477 12.2132 45.9369 13.1597 46.1616L8.76925 56.1201C7.96466 55.5735 7.49857 54.8997 7.37098 54.0987ZM15.9885 51.9303L14.9574 54.269C14.4519 55.4158 13.8603 56.2123 13.1828 56.6587C12.5053 57.105 11.6883 57.2136 10.7317 56.9845L15.1222 47.026C15.9368 47.577 16.4079 48.253 16.5355 49.054C16.6676 49.8449 16.4852 50.8037 15.9885 51.9303ZM11.6753 78.665L0 76.9905L0.37957 74.3464L9.95832 67.2914L1.56514 66.0877L1.94002 63.4762L13.6154 65.1507L13.2358 67.7948L3.64071 74.8474L12.0502 76.0535L11.6753 78.665ZM148.295 80.4615L160 81.9116L158.785 91.7134C158.634 92.9243 158.212 93.8246 157.519 94.4143C156.824 95.015 155.854 95.2382 154.61 95.0841C153.366 94.9299 152.48 94.4768 151.953 93.7247C151.424 92.9836 151.235 92.0075 151.385 90.7966L152.276 83.6131L147.97 83.0797L148.295 80.4615ZM156.695 91.1388L157.547 84.2661L154.42 83.8788L153.552 90.7494C153.492 91.2294 153.567 91.6097 153.776 91.8904C153.983 92.1819 154.371 92.3629 154.939 92.4332C155.517 92.5048 155.937 92.424 156.199 92.1905C156.47 91.9694 156.635 91.6188 156.695 91.1388ZM145.915 97.3548L156.973 101.455L156.055 103.929L147.007 100.574L144.007 108.659L141.996 107.914L145.915 97.3548ZM148.391 120.901L141.491 109.965L139.906 112.357L141.363 114.666L137.655 120.261L134.959 119.821L133.374 122.213L146.141 124.297L148.391 120.901ZM139.972 120.647L142.623 116.647L145.606 121.371L145.488 121.55L139.972 120.647ZM127.577 128.374L130.396 131.495L140.122 132.936L137.698 135.124L130.92 134.043L131.32 140.881L128.895 143.07L128.436 133.286L125.606 130.154L127.577 128.374ZM117.216 150.849L112.866 139.891L110.413 140.864L113.546 148.757L102.654 143.941L100.17 144.926L104.52 155.884L106.973 154.911L103.846 147.034L114.732 151.834L117.216 150.849ZM90.304 146.965C92.3923 146.738 94.0644 147.06 95.3202 147.93C96.5773 148.812 97.3124 150.236 97.5257 152.203C97.7377 154.159 97.3237 155.697 96.2835 156.815C95.2444 157.945 93.6425 158.627 91.4777 158.862L88.5256 159.181C86.3607 159.416 84.6498 159.093 83.3928 158.212C82.1369 157.341 81.403 155.928 81.1909 153.972C80.9776 152.005 81.3905 150.456 82.4296 149.327C83.4698 148.208 85.045 147.534 87.1551 147.306L90.304 146.965ZM91.0662 156.75C92.2798 156.619 93.2019 156.298 93.8324 155.787C94.4629 155.277 94.8141 154.536 94.8859 153.567L84.0617 154.739C84.3397 155.671 84.8413 156.319 85.5666 156.682C86.2919 157.046 87.2613 157.162 88.475 157.031L91.0662 156.75ZM90.1906 149.133L87.6486 149.408C86.424 149.541 85.502 149.862 84.8824 150.371C84.2519 150.882 83.9013 151.627 83.8306 152.608L94.6549 151.436C94.3757 150.493 93.8735 149.84 93.1482 149.476C92.4229 149.112 91.4371 148.998 90.1906 149.133ZM75.6096 160L76.342 148.16L74.1646 147.779L68.8987 150.691L64.951 146.168L62.7736 145.787L59.4412 157.173L62.0412 157.628L64.4999 149.32L67.269 152.348L66.2173 158.358L68.8173 158.812L69.8661 152.819L73.5347 150.899L73.0097 159.545L75.6096 160ZM45.6484 138.952L38.5715 148.383L30.6664 142.457C29.6898 141.725 29.118 140.912 28.9508 140.017C28.7748 139.116 29.063 138.164 29.8152 137.161C30.5674 136.159 31.401 135.616 32.316 135.532C33.2222 135.442 34.1636 135.763 35.1402 136.495L40.9338 140.838L43.5369 137.369L45.6484 138.952ZM32.2039 140.93L37.7467 145.086L39.6372 142.566L34.1043 138.398C33.7171 138.108 33.3498 137.983 33.0023 138.025C32.646 138.06 32.2962 138.307 31.9531 138.764C31.6034 139.23 31.4648 139.634 31.5374 139.977C31.5946 140.323 31.8168 140.64 32.2039 140.93ZM23.1605 136.054L32.1957 128.476L24.9532 119.849L23.3105 121.227L28.8563 127.833L21.4638 134.033L23.1605 136.054ZM23.4202 118.387L10.4968 118.955L8.66203 115.319L16.8015 105.269L18.094 107.831L16.375 109.953L19.3984 115.945L22.1276 115.825L23.4202 118.387ZM17.0527 116.057L14.8911 111.772L11.3723 116.113L11.4689 116.305L17.0527 116.057ZM10.2582 98.2145L14.3677 97.3166L13.8006 94.7232L9.67491 95.6245L0.949684 91.1678L1.64716 94.3573L7.78459 97.4047L3.48245 102.75L4.17993 105.939L10.2582 98.2145ZM97.8867 14.4955L99.1701 10.4914L95.5312 1.36158L98.6418 2.35766L101.111 8.7583L106.827 4.97866L109.937 5.97474L101.704 11.2856L100.416 15.3055L97.8867 14.4955ZM122.337 12.0151L115.056 21.2897L117.132 22.9184L122.377 16.2381L123.699 28.0692L125.801 29.7183L133.083 20.4437L131.006 18.815L125.772 25.4823L124.44 13.6642L122.337 12.0151ZM132.748 37.3748C131.5 35.686 130.935 34.0803 131.054 32.5575C131.182 31.0283 132.042 29.6758 133.634 28.5002C135.218 27.3312 136.755 26.9137 138.246 27.2478C139.746 27.5753 141.143 28.6144 142.436 30.3651L144.201 32.7525C145.494 34.5032 146.077 36.1431 145.95 37.6724C145.831 39.1951 144.98 40.541 143.396 41.7101C141.804 42.8857 140.258 43.3097 138.758 42.9822C137.267 42.6481 135.891 41.6278 134.63 39.9213L132.748 37.3748ZM140.819 31.7846C140.094 30.8031 139.352 30.1689 138.593 29.882C137.834 29.595 137.017 29.6649 136.143 30.0916L142.612 38.8451C143.277 38.1355 143.584 37.3759 143.533 36.5665C143.481 35.757 143.093 34.8616 142.368 33.8801L140.819 31.7846ZM134.679 36.3798L136.198 38.4355C136.93 39.4258 137.672 40.06 138.424 40.3382C139.183 40.6251 140.004 40.552 140.887 40.1187L134.418 31.3652C133.744 32.0814 133.433 32.8442 133.484 33.6537C133.536 34.4631 133.934 35.3718 134.679 36.3798ZM151.282 43.1548L140.683 48.4918L141.451 50.5634L146.623 53.6406L144.704 59.3288L145.473 61.4004L156.991 58.5369L156.073 56.0634L147.655 58.1293L148.876 54.2121L154.598 52.0903L153.68 49.6168L147.973 51.7329L144.465 49.5339L152.2 45.6283L151.282 43.1548Z"
                                            fill="black" />
                                    </svg>
                                    <svg width="40" height="40" viewBox="0 0 40 40" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <mask style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="40"
                                            height="40">
                                            <path d="M0 0H40V40H0V0Z" fill="white" />
                                        </mask>
                                        <g>
                                            <path d="M11.668 6.66663V33.3333L33.3346 20L11.668 6.66663Z"
                                                stroke="#FF640D" stroke-width="2" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                        </g>
                                    </svg>
                                </span>
                            </a>
                            <img src="assets/images/common_img/video_img_1.png" alt="traning_video" class="h-100">
                        </div>
                    </div>
                </div>
            </div>
            <div class="overlay-video">
                <div class="videoWrapperExt">
                    <div class="videoWrapper">
                        <div class="close">
                            <svg class="close-button-icon-video" viewBox="0 0 24 24">
                                <path d="M5.5 5.5L18.5 18.5M18.5 5.5L5.5 18.5" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round"></path>
                            </svg>
                        </div>
                        <iframe id="player" width="853" height="480" allow="autoplay; encrypted-media"
                            allowfullscreen></iframe>
                    </div>
                </div>
            </div>
        </div>
        <!-- Traning-Video End -->

        <!--  -->
        <section>
            <!-- Gym-Counter Start -->
            <div class="counter_sec sec_padding">
                <div class="container">
                    <div class="counter_area" data-aos="fade-up" data-aos-anchor-placement="top-bottom">
                        <div class="row">
                            <!-- Years of Experience -->
                            <div class="col-lg-3 col-md-6">
                                <div class="counter_box">
                                    <h2 class="counter_strok_text counter" aria-label="03">03</h2>
                                    <h2 class="counter" aria-label="03">03</h2>
                                    <p class="satoshi_fontfamily fw_500 line_height_normal">Years of Experience</p>
                                </div>
                            </div>

                            <!-- Skilled Trainers -->
                            <div class="col-lg-3 col-md-6">
                                <div class="counter_box">
                                    <h2 class="counter_strok_text counter" aria-label="10+">10+</h2>
                                    <h2 class="counter" aria-label="10+">10+</h2>
                                    <p class="satoshi_fontfamily fw_500 line_height_normal">Skilled Trainers</p>
                                </div>
                            </div>

                            <!-- Calories Burned -->
                            <div class="col-lg-3 col-md-6">
                                <div class="counter_box">
                                    <h2 class="counter_strok_text counter" aria-label="8k+">8k+</h2>
                                    <h2 class="counter" aria-label="8k+">8k+</h2>
                                    <p class="satoshi_fontfamily fw_500 line_height_normal">Calories Burned</p>
                                </div>
                            </div>

                            <!-- Happy Members -->
                            <div class="col-lg-3 col-md-6">
                                <div class="counter_box">
                                    <h2 class="counter_strok_text counter" aria-label="1.1k">1.1k</h2>
                                    <h2 class="counter" aria-label="1.1k">1.1k</h2>
                                    <h3 class="d-none">hidden</h3>
                                    <h4 class="d-none">hidden</h4>
                                    <p class="satoshi_fontfamily fw_500 line_height_normal">Happy Members</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Gym-Counter End -->

            <!-- Meet-Team Slider Start -->
            <div class="traning_slider_sec sec_padding_bottom">
                <div class="meet_team_v1">
                    <div class="container">
                        <div class="traning_slider">
                            <div class="row">
                                <div class="col-12">
                                    <div class="common_title_area meet_team_title text-center">
                                        <h5 class="satoshi_fontfamily fw_500 line_height_normal color_orange"
                                            data-aos="fade-down">Our Trainers</h5>
                                        <h3 class="pt-10 reveal custom_lightSpeedInLeft">MEET OUR SKILLED TEAM</h3>
                                        <h4 class="d-none">hidden</h4>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="traning_slider_area" data-aos="zoom-in">

                                        <!-- Trainer 1: Vaibhav Arora -->
                                        <div class="traning_slider_item">
                                            <div class="triners_img">
                                                <img src="assets/images/common_img/triners_1.png" alt="Vaibhav Arora">
                                            </div>
                                            <div class="triners_info">
                                                <h5 class="line_height_normal">
                                                    <a href="our-team-v1" class="color_black triners_name">VAIBHAV
                                                        ARORA</a>
                                                </h5>
                                                <p class="satoshi_fontfamily fw_500 color_lightblack">Trainer</p>

                                                <p class="satoshi_fontfamily fw_400 color_lightblack">Specialization:
                                                    Powerlifting</p>
                                            </div>
                                        </div>

                                        <!-- Trainer 2: Abhiraj Gupta -->
                                        <div class="traning_slider_item">
                                            <div class="triners_img">
                                                <img src="assets/images/common_img/triners_2.png" alt="Abhiraj Gupta">
                                            </div>
                                            <div class="triners_info">
                                                <h5 class="line_height_normal">
                                                    <a href="our-team-v1" class="color_black triners_name">ABHIRAJ
                                                        GUPTA</a>
                                                </h5>
                                                <p class="satoshi_fontfamily fw_500 color_lightblack">Owner & Trainer
                                                </p>
                                                <p class="satoshi_fontfamily fw_400 color_lightblack">Specialization:
                                                    Powerlifting & Bodybuilding</p>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Meet-Team Slider End -->
        </section>
        <!--  -->

        <!-- Client-Say Slider Start -->
        <div class="client_say_slider_sec">
            <div class="client_say_slider_v1_bg">
                <div class="client_say_slider_area">
                    <div class="client_say_slider_list client_say_slider_v1 lazy">
                        <div class="client_say_slider_item">
                            <div class="client_say_info">
                                <h5 class="satoshi_fontfamily line_height_36 fw_500_italic color_white"
                                    data-animation-in="fadeInDown" data-delay-in="0.2">"I've been going to Gymort
                                    Fitness Center for about 6 months now and I'm really happy with it. The facilities
                                    are great, with a wide variety of equipment and plenty of space to work out. The
                                    staff is also very friendly and helpful, and they're always happy to answer any
                                    questions I have. I've seen some great results since I started working out at
                                    Gymort, and I'm really glad I found this gym."</h5>
                            </div>
                            <div class="client_say_img_info pt-60" data-animation-in="fadeInUp" data-delay-in="0.2">
                                <div class="client_say_img">
                                    <img src="assets/images/common_img/client_say_v1_img_1.png" alt="client_say_image">
                                </div>
                                <div class="client_say_img_detail">
                                    <h5 class="line_height_normal color_white">ALEXIS MORTON</h5>
                                    <p class="satoshi_fontfamily line_height_normmal fw_500 color_white pt-10">Customers
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="client_say_slider_item">
                            <div class="client_say_info">
                                <h5 class="satoshi_fontfamily line_height_36 fw_500_italic color_white"
                                    data-animation-in="fadeInDown" data-delay-in="0.2">"The staff is also very friendly
                                    and helpful, and they're always happy to answer any questions I have. I've seen some
                                    great results since I started working out at Gymort, and I'm really glad I found
                                    this gym."</h5>
                            </div>
                            <div class="client_say_img_info pt-60" data-animation-in="fadeInUp" data-delay-in="0.2">
                                <div class="client_say_img">
                                    <img src="assets/images/common_img/client_say_v1_img_2.png" alt="client_say_image">
                                </div>
                                <div class="client_say_img_detail">
                                    <h5 class="line_height_normal color_white">ALISA FOX</h5>
                                    <p class="satoshi_fontfamily line_height_normmal fw_500 color_white pt-10">Customers
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Client-Say Slider End -->

        <!-- Pricing-Plans Start -->
        <section class="pricing_plan_sec">
            <div class="container">
                <div class="pricing_plans sec_padding" id="pricing_v1">
                    <div class="row justify-content-center">
                        <div class="col-lg-10 col-12">
                            <div class="common_title_area pricing_plans_title text-center">
                                <h5
                                    class="satoshi_fontfamily fw_500 line_height_normal color_orange reveal custom_fade_top">
                                    Membership Plans</h5>
                                <h3 class="pt-10 reveal custom_lightSpeedInLeft">FIT FOR EVERY BUDGET, ACHIEVE YOUR
                                    GOALS</h3>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="pricing_plans_area pt-60">
                                <div class="row">

                                    <!-- Monthly Plan -->
                                    <div class="col-xl-3 col-md-6 mb-4">
                                        <div class="pricing_plan_v1_box h-100 d-flex flex-column">
                                            <div class="pricing_head_area">
                                                <h4 class="color_orange">Monthly Plan</h4>
                                            </div>
                                            <div class="pricing_mid_area">
                                                <h2>₹1,500</h2>
                                                <p class="satoshi_fontfamily fw_500 pt-10">PER MONTH</p>
                                            </div>
                                            <div
                                                class="pricing_bottom_area overflow-hidden flex-grow-1 d-flex flex-column">
                                                <ul class="pricing_bottom_item_list flex-grow-1">
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Access to all
                                                        gym facilities</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">No contract
                                                        required</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Pay as you go
                                                    </li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Basic
                                                        amenities included</li>
                                                </ul>
                                                <div class="purches_btn reveal custom_fade_buttom">
                                                    <a href="pricing-plans-v1" class="orange_btn">
                                                        <span class="orenge_text orangeglow_btn" data-hover="Join Now">
                                                            Join Now
                                                        </span>
                                                        <span class="orenge_icon whiteglow_btn">
                                                            <img src="assets/images/svgs/common_button_arrow.svg"
                                                                alt="common_button_arrow">
                                                        </span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- 3 Months Plan -->
                                    <div class="col-xl-3 col-md-6 mb-4">
                                        <div class="pricing_plan_v1_box h-100 d-flex flex-column">
                                            <div class="pricing_head_area">
                                                <h4 class="color_orange">3 Months Plan</h4>
                                            </div>
                                            <div class="pricing_mid_area">
                                                <h2>₹4,000</h2>
                                                <p class="satoshi_fontfamily fw_500 pt-10">FOR 3 MONTHS</p>
                                                <p class="satoshi_fontfamily fw_500 color_orange">Save ₹500</p>
                                            </div>
                                            <div
                                                class="pricing_bottom_area overflow-hidden flex-grow-1 d-flex flex-column">
                                                <ul class="pricing_bottom_item_list flex-grow-1">
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Access to all
                                                        gym facilities</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Includes 1
                                                        Creatine (30 servings)</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Locker access
                                                        included</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Free fitness
                                                        assessment</li>
                                                </ul>
                                                <div class="purches_btn reveal custom_fade_buttom mt-auto">
                                                    <a href="pricing-plans-v1" class="orange_btn">
                                                        <span class="orenge_text orangeglow_btn" data-hover="Join Now">
                                                            Join Now
                                                        </span>
                                                        <span class="orenge_icon whiteglow_btn">
                                                            <img src="assets/images/svgs/common_button_arrow.svg"
                                                                alt="common_button_arrow">
                                                        </span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- 6 Months Plan -->
                                    <div class="col-xl-3 col-md-6 mb-4">
                                        <div class="pricing_plan_v1_box popular_plan h-100 d-flex flex-column">
                                            <div class="popular_badge text-center">
                                                <span class="badge bg-warning text-dark fw-bold">MOST POPULAR</span>
                                            </div>
                                            <div class="pricing_head_area">
                                                <h4 class="color_orange">6 Months Plan</h4>
                                            </div>
                                            <div class="pricing_mid_area">
                                                <h2>₹7,500</h2>
                                                <p class="satoshi_fontfamily fw_500 pt-10">FOR 6 MONTHS</p>
                                                <p class="satoshi_fontfamily fw_500 color_orange">Save ₹1,500</p>
                                            </div>
                                            <div
                                                class="pricing_bottom_area overflow-hidden flex-grow-1 d-flex flex-column">
                                                <ul class="pricing_bottom_item_list flex-grow-1">
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Access to all
                                                        gym facilities</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Includes 1
                                                        Pre-workout</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Includes
                                                        Premium Shaker</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">2 Personal
                                                        training sessions</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Nutrition
                                                        consultation</li>
                                                </ul>
                                                <div class="purches_btn reveal custom_fade_buttom mt-auto">
                                                    <a href="pricing-plans-v1" class="orange_btn">
                                                        <span class="orenge_text orangeglow_btn" data-hover="Join Now">
                                                            Join Now
                                                        </span>
                                                        <span class="orenge_icon whiteglow_btn">
                                                            <img src="assets/images/svgs/common_button_arrow.svg"
                                                                alt="common_button_arrow">
                                                        </span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Annual Plan -->
                                    <div class="col-xl-3 col-md-6 mb-4">
                                        <div class="pricing_plan_v1_box h-100 d-flex flex-column">
                                            <div class="pricing_head_area">
                                                <h4 class="color_orange">Annual Plan</h4>
                                            </div>
                                            <div class="pricing_mid_area">
                                                <h2>₹14,000</h2>
                                                <p class="satoshi_fontfamily fw_500 pt-10">FOR 12 MONTHS</p>
                                                <p class="satoshi_fontfamily fw_500 color_orange">Save ₹4,000</p>
                                            </div>
                                            <div
                                                class="pricing_bottom_area overflow-hidden flex-grow-1 d-flex flex-column">
                                                <ul class="pricing_bottom_item_list flex-grow-1">
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Access to all
                                                        gym facilities</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Includes 1kg
                                                        Whey Protein</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Includes
                                                        Premium Gym Bag</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Includes Pro
                                                        Gym Gloves</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">6 Personal
                                                        training sessions</li>
                                                    <li class="color_lightblack fw_500 satoshi_fontfamily">Priority
                                                        booking for classes</li>
                                                </ul>
                                                <div class="purches_btn reveal custom_fade_buttom mt-auto">
                                                    <a href="pricing-plans-v1" class="orange_btn">
                                                        <span class="orenge_text orangeglow_btn" data-hover="Join Now">
                                                            Join Now
                                                        </span>
                                                        <span class="orenge_icon whiteglow_btn">
                                                            <img src="assets/images/svgs/common_button_arrow.svg"
                                                                alt="common_button_arrow">
                                                        </span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div> <!-- row -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <style>
            .pricing_plan_v1_box {
                background: #fff;
                border-radius: 15px;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
                padding: 30px 25px;
                transition: all 0.3s ease;
                border: 1px solid #f0f0f0;
                position: relative;
            }

            .pricing_plan_v1_box:hover {
                transform: translateY(-5px);
                box-shadow: 0 15px 40px rgba(0, 0, 0, 0.12);
            }

            .popular_plan {
                border: 2px solid #FFC107;
                transform: scale(1.02);
            }

            .popular_plan:hover {
                transform: translateY(-5px) scale(1.02);
            }

            .popular_badge {
                position: absolute;
                top: -12px;
                left: 50%;
                transform: translateX(-50%);
                z-index: 1;
            }

            .popular_badge .badge {
                padding: 8px 20px;
                border-radius: 20px;
                font-size: 12px;
                text-transform: uppercase;
                letter-spacing: 0.5px;
            }

            .pricing_head_area {
                text-align: center;
                margin-bottom: 20px;
            }

            .pricing_head_area h4 {
                font-size: 22px;
                font-weight: 600;
                margin: 0;
            }

            .pricing_mid_area {
                text-align: center;
                padding: 20px 0;
                border-top: 1px solid #f0f0f0;
                border-bottom: 1px solid #f0f0f0;
                margin-bottom: 25px;
            }

            .pricing_mid_area h2 {
                font-size: 42px;
                font-weight: 700;
                color: #2D2D2D;
                margin: 0;
            }

            .pricing_mid_area p {
                margin: 5px 0 0 0;
                font-size: 14px;
            }

            .pricing_bottom_item_list {
                list-style: none;
                padding: 0;
                margin: 0 0 25px 0;
            }

            .pricing_bottom_item_list li {
                /* padding: 12px 0; */
                border-bottom: 1px solid #f5f5f5;
                position: relative;
                /* padding-left: 25px; */
            }



            .pricing_bottom_item_list li:last-child {
                border-bottom: none;
            }

            .purches_btn {
                text-align: center;
            }




            /* Ensure equal height for all cards */
            .pricing_plans_area .row {
                display: flex;
                flex-wrap: wrap;
            }

            .pricing_plans_area .row>div {
                display: flex;
            }

            @media (max-width: 768px) {
                .pricing_plan_v1_box {
                    margin-bottom: 30px;
                }

                .popular_plan {
                    transform: scale(1);
                }

                .popular_plan:hover {
                    transform: translateY(-5px);
                }
            }
        </style>

        <!-- Pricing-Plans End -->




        <!-- Gym-Marqueer-Text Start -->
        <?php include 'assets/config/slider.php'; ?>

        <!-- Gym-Marqueer-Text End -->

        <!-- footer Start -->
        <?php include 'assets/config/footer.php' ?>
        <!-- footer End -->

        <!-- Scroll-Top Start -->
        <div class="scrolltop_area orangeglow">
            <button id="scroll-top-btn">
                <span class="scroll-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <mask style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="24" height="24">
                            <path d="M0 0H24V24H0V0Z" fill="white" />
                        </mask>
                        <g>
                            <path d="M7 11L12 6L17 11" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path d="M7 17L12 12L17 17" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                        </g>
                    </svg>
                </span>
                <span id="scroll-percentage"></span>
            </button>
        </div>
        <!-- Scroll-Top End -->

        <!-- custome mouse -->
        <div class="megic-cursor">
            <div class="megic-cursor-item"></div>
        </div>

    </div>

    <!-- JS Here -->
    <script src="assets/js/jquery-3.7.1.js"></script>
    <script src="assets/js/myplugin.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/slick-animation.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script src="assets/js/plugins.js"></script>
    <script src="assets/js/TweenMax.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/allsliders.js"></script>
    <script src="assets/js/custome-cursor.js"></script>
    <script src="assets/js/style.js"></script>

    <!-- AOS Animation -->
    <script>
        AOS.init({
            duration: 1600,
        });
        AOS.init();
    </script>
</body>


</html>