<?php include 'connect.php' ?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buy Now - Barbell Life – Unisex Gym</title>
    <!-- CSS Here -->
    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/x-icon">
    <link href="https://fonts.googleapis.com/css2?family=Zen+Dots&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/all.min.css">
    <link rel="stylesheet" href="assets/css/slick.css">
    <link rel="stylesheet" href="assets/css/animate_plugin.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/aos.css">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/media-query.css">
    <link rel="stylesheet" href="assets/css/product-details.css">
    
    <!-- Custom CSS for the modal -->
    <style>
        .modal-content {
            border-radius: 15px;
            border: none;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
            font-family: "Merriweather", Georgia, serif !important;
        }
        
        .modal-header {
            background: linear-gradient(135deg, #ff7b00 0%, #ff5500 100%);
            color: white;
            border-radius: 15px 15px 0 0;
            padding: 15px 20px;
        }
        
        .modal-title {
            font-weight: 600;
            font-size: 18px;
        }
        
        .modal-body {
            padding: 25px;
            font-family: "Merriweather", Georgia, serif !important;

        }
        
        .form-label {
            font-weight: 500;
            color: #333;
            margin-bottom: 5px;
        }
        
        .form-control {
            border-radius: 8px;
            padding: 12px 15px;
            border: 1px solid #ddd;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: #ff7b00;
            box-shadow: 0 0 0 0.25rem rgba(255, 123, 0, 0.25);
        }
        
        .btn-whatsapp {
            background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
            color: white;
            border: none;
            border-radius: 8px;
            padding: 12px 20px;
            font-weight: 600;
            width: 100%;
            transition: all 0.3s;
        }
        
        .btn-whatsapp:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(37, 211, 102, 0.4);
        }
        
        .product-summary {
            background-color: #f8f9fa;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .product-summary img {
            max-width: 80px;
            border-radius: 8px;
        }
        
        .required-field::after {
            content: "*";
            color: #ff0000;
            margin-left: 3px;
        }
    </style>
</head>

<body>
    <!-- Preloader Start -->
    <div class="preloader">
        <div class="preloader-content">
            <div class="preloader_img_circle"></div>
            <div class="preloader_img">
                <img src="assets/images/preloader/fitness_preimg.gif" alt="fitness_preimg">
            </div>
        </div>
    </div>
    <!-- Preloader end -->

 <section class="commom_banner_sec" id="commom_banner_sec">
            <div class="common_banner_bg">
                <div class="container">
                    <div class="common_banner_content text-lg-start text-center">
                        <h1 class="d-none">hidden</h1>
                        <h2 class="d-none">hidden</h2>
                        <h3 class="d-none">hidden</h3>
                        <h4 class="d-none">hidden</h4>
                        <h5 class="satoshi_fontfamily line_height_normal fw_500 color_white" data-aos="fade-down">
                            <a href="index" class="color_white">Home</a> / <span class="color_orange">Shop</span>
                        </h5>
                        <h2 class="color_white line_height_normal pt-20" data-aos="fade-down">Shop</h2>
                        <h3 class="d-none">hidden</h3>
                        <h4 class="d-none">hidden</h4>
                    </div>
                </div>
            </div>
        </section>

    <div class="site_content">
        <!-- Header Start -->
        <?php include 'assets/config/header.php' ?>
        <!-- Header end -->

        <!-- Check if we're on a product details page -->
        <?php
        // Check if product name is provided in URL
        if(isset($_GET['product'])) {
            $product_name = urldecode($_GET['product']);
            
            // Fetch product details by name
            $sql = "SELECT p.*, pi.image_path 
                    FROM products p 
                    LEFT JOIN product_images pi ON p.id = pi.product_id AND pi.is_primary = 1 
                    WHERE p.name = ? AND p.status = 'active'";
            
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("s", $product_name);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if($result->num_rows > 0) {
                $product = $result->fetch_assoc();
                
                // Fetch all images for this product
                $image_sql = "SELECT image_path FROM product_images WHERE product_id = ?";
                $image_stmt = $conn->prepare($image_sql);
                $image_stmt->bind_param("i", $product['id']);
                $image_stmt->execute();
                $image_result = $image_stmt->get_result();
                $product_images = [];
                
                while($image_row = $image_result->fetch_assoc()) {
                    $product_images[] = $image_row['image_path'];
                }
        ?>
        
        <!-- Product Details Section -->
        <section class="product-details-page" style="font-family: 'Merriweather' Georgia, serif;">
            <div class="container">
                <div class="row">
                    <!-- Product Gallery -->
                    <div class="col-lg-6">
                        <div class="product-gallery">
                            <div class="main-product-image">
                                <img id="main-product-img" src="admin/<?php echo $product_images[0]; ?>" alt="<?php echo htmlspecialchars($product['name']); ?>">
                            </div>
                            <?php if(count($product_images) > 1): ?>
                            <div class="thumbnail-images">
                                <?php foreach($product_images as $index => $image): ?>
                                <div class="thumbnail <?php echo $index === 0 ? 'active' : ''; ?>" data-image="admin/<?php echo $image; ?>">
                                    <img src="admin/<?php echo $image; ?>" alt="Thumbnail <?php echo $index + 1; ?>">
                                </div>
                                <?php endforeach; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Product Details -->
                    <div class="col-lg-6">
                        <div class="product-details">
                            <h1 class="product-title-large"><?php echo htmlspecialchars($product['name']); ?></h1>
                            
                            <div class="product-price-large">
                                <span class="original-price">₹<?php echo number_format($product['price'] * 1.2, 2); ?></span>
                                ₹<?php echo number_format($product['price'], 2); ?>
                            </div>
                            
                            <div class="product-info-list">
                                <div class="product-info-item">
                                    <span class="info-label">Availability:</span>
                                    <span class="info-value <?php echo $product['stock_quantity'] > 0 ? 'text-success' : 'text-danger'; ?>">
                                        <?php echo $product['stock_quantity'] > 0 ? 'In Stock' : 'Out of Stock'; ?>
                                    </span>
                                </div>
                                <div class="product-info-item">
                                    <span class="info-label">SKU:</span>
                                    <span class="info-value"><?php echo $product['sku']; ?></span>
                                </div>
                                <div class="product-info-item">
                                    <span class="info-label">Weight:</span>
                                    <span class="info-value"><?php echo $product['weight_value']; ?> <?php echo $product['weight_unit']; ?></span>
                                </div>
                            </div>
                            
                            <div class="action-buttons">
                                <button class="btn-buy-now" data-bs-toggle="modal" data-bs-target="#buyNowModal">
                                    <i class="fas fa-bolt"></i> BUY NOW
                                </button>
                            </div>
                            
                            <div class="product-description">
                                <h3 style="font-size: 32px;">Description</h3>
                                <div class="description-content">
                                    <?php echo $product['description']; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- Buy Now Modal -->
        <div class="modal fade" id="buyNowModal" tabindex="-1" aria-labelledby="buyNowModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="buyNowModalLabel">Complete Your Purchase</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="product-summary d-flex align-items-center mb-4">
                            <img src="admin/<?php echo $product_images[0]; ?>" alt="<?php echo htmlspecialchars($product['name']); ?>" class="me-3">
                            <div>
                                <h5 class="mb-1" style="font-size: 16px;"><?php echo htmlspecialchars($product['name']); ?></h5>
                                <p class="mb-0 fw-bold" style="font-size: 16px;">₹<?php echo number_format($product['price'], 2); ?></p>
                            </div>
                        </div>
                        
                        <form id="buyNowForm">
                            <input type="hidden" name="product_name" value="<?php echo htmlspecialchars($product['name']); ?>">
                            <input type="hidden" name="product_price" value="<?php echo $product['price']; ?>">
                            
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label for="quantity" class="form-label required-field">Quantity</label>
                                    <input type="number" class="form-control" id="quantity" name="quantity" min="1" value="1" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="name" class="form-label required-field">Full Name</label>
                                    <input type="text" class="form-control" id="name" name="name" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="phone" class="form-label required-field">Phone Number</label>
                                    <input type="tel" class="form-control" id="phone" name="phone" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="email" class="form-label required-field">Email Address</label>
                                    <input type="email" class="form-control" id="email" name="email" required>
                                </div>
                                <div class="col-4 mb-3">
                                    <label for="address" class="form-label required-field">Street Address</label>
                                    <input type="text" class="form-control" id="address" name="address" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="city" class="form-label required-field">City</label>
                                    <input type="text" class="form-control" id="city" name="city" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="state" class="form-label required-field">State</label>
                                    <input type="text" class="form-control" id="state" name="state" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="pincode" class="form-label required-field">Pincode</label>
                                    <input type="text" class="form-control" id="pincode" name="pincode" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="country" class="form-label required-field">Country</label>
                                    <input type="text" class="form-control" id="country" name="country" value="India" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="landmark" class="form-label">Landmark (Optional)</label>
                                    <input type="text" class="form-control" id="landmark" name="landmark">
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-whatsapp mt-3">
                                <i class="fab fa-whatsapp me-2"></i> Complete Purchase via WhatsApp
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <?php
            } else {
                // Product not found, show shop page instead
                include 'shop_content.php';
            }
        } else {
            // No product specified, show shop page
            include 'shop_content.php';
        }
        
        // Function to include shop content
        function include_shop_content() {
            global $conn;
        ?>
        
        <!-- Shop Section Start -->
        <section class="shop-page">
            <div class="container">
                <div class="shop-header">
                    <h3>Our Products</h3>
                    <div class="products-count">
                        <?php
                        // Get total number of products
                        $sql = "SELECT COUNT(*) as total FROM products WHERE status = 'active'";
                        $result = $conn->query($sql);
                        $total_products = $result->fetch_assoc()['total'];
                        
                        // Calculate total pages (24 products per page)
                        $products_per_page = 24;
                        $total_pages = ceil($total_products / $products_per_page);
                        
                        // Get current page
                        $current_page = isset($_GET['page']) ? $_GET['page'] : 1;
                        $offset = ($current_page - 1) * $products_per_page;
                        
                        echo "Showing " . (($current_page - 1) * $products_per_page + 1) . " - " . 
                             min($current_page * $products_per_page, $total_products) . " of $total_products products";
                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <?php
                    // Fetch products with their primary images
                    $sql = "SELECT p.*, pi.image_path 
                            FROM products p 
                            LEFT JOIN product_images pi ON p.id = pi.product_id AND pi.is_primary = 1 
                            WHERE p.status = 'active' 
                            ORDER BY p.created_at DESC 
                            LIMIT $offset, $products_per_page";
                    
                    $result = $conn->query($sql);
                    
                    if ($result->num_rows > 0) {
                        while($row = $result->fetch_assoc()) {
                            $product_url = "?product=" . urlencode($row['name']);
                            echo '
                            <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                                <div class="product-card" data-aos="fade-up">
                                    <div class="product-image">
                                        <img src="admin/' . htmlspecialchars($row['image_path'], ENT_QUOTES, 'UTF-8') . '" 
                     alt="' . htmlspecialchars($row['name'], ENT_QUOTES, 'UTF-8') . '">
                                        <div class="product-hover-actions">
                                            <div class="action-btn" title="Add to Cart">
                                                <i class="fas fa-shopping-cart"></i>
                                            </div>
                                            <a href="' . $product_url . '" class="action-btn" title="Quick View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="product-info">
                                        <h3 class="product-title">' . htmlspecialchars($row['name']) . '</h3>
                                        <div class="product-price">₹' . number_format($row['price'], 2) . '</div>
                                        <div class="product-stock">In Stock: ' . $row['stock_quantity'] . '</div>
                                        <div class="product-weight">Weight: ' . $row['weight_value'] . ' ' . $row['weight_unit'] . '</div>
                                    </div>
                                </div>
                            </div>';
                        }
                    } else {
                        echo '<div class="col-12 text-center"><p>No products found.</p></div>';
                    }
                    ?>
                </div>
                
                <!-- Pagination -->
                <?php if ($total_pages > 1): ?>
                <div class="pagination-container">
                    <nav aria-label="Page navigation">
                        <ul class="pagination justify-content-center">
                            <?php if ($current_page > 1): ?>
                            <li class="page-item">
                                <a class="page-link" href="?page=<?php echo $current_page - 1; ?>" aria-label="Previous">
                                    <span aria-hidden="true">&laquo;</span>
                                </a>
                            </li>
                            <?php endif; ?>
                            
                            <?php 
                            // Show page numbers
                            $start_page = max(1, $current_page - 2);
                            $end_page = min($total_pages, $start_page + 4);
                            
                            // Adjust if we're near the end
                            if ($end_page - $start_page < 4) {
                                $start_page = max(1, $end_page - 4);
                            }
                            
                            for ($i = $start_page; $i <= $end_page; $i++): 
                            ?>
                            <li class="page-item <?php echo ($i == $current_page) ? 'active' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                            </li>
                            <?php endfor; ?>
                            
                            <?php if ($current_page < $total_pages): ?>
                            <li class="page-item">
                                <a class="page-link" href="?page=<?php echo $current_page + 1; ?>" aria-label="Next">
                                    <span aria-hidden="true">&raquo;</span>
                                </a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
        }
        // Call the function to show shop content if not on product page
        if(!isset($_GET['product'])) {
            include_shop_content();
        }
        ?>
        <!-- Shop Section End -->

        <!-- Gym-Marqueer-Text Start -->
        <?php include 'assets/config/slider.php'; ?>
        <!-- Gym-Marqueer-Text End -->

        <!-- footer Start -->
        <?php include 'assets/config/footer.php'; ?>
        <!-- footer End -->

        <!-- Scroll-Top Start -->
        <div class="scrolltop_area orangeglow">
            <button id="scroll-top-btn">
                <span class="scroll-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <mask style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="24" height="24">
                            <path d="M0 0H24V24H0V0Z" fill="white" />
                        </mask>
                        <g>
                            <path d="M7 11L12 6L17 11" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path d="M7 17L12 12L17 17" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                        </g>
                    </svg>
                </span>
                <span id="scroll-percentage"></span>
            </button>
        </div>
        <!-- Scroll-Top End -->

        <!-- custome mouse -->
        <div class="megic-cursor">
            <div class="megic-cursor-item"></div>
        </div>
    </div>

    <!-- JS Here -->
    <script src="assets/js/jquery-3.7.1.js"></script>
    <script src="assets/js/myplugin.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/slick-animation.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script src="assets/js/plugins.js"></script>
    <script src="assets/js/TweenMax.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/allsliders.js"></script>
    <script src="assets/js/custome-cursor.js"></script>
    <script src="assets/js/style.js"></script>

    <script>
        // Product gallery functionality
        document.addEventListener('DOMContentLoaded', function() {
            // Thumbnail click event
            const thumbnails = document.querySelectorAll('.thumbnail');
            if(thumbnails.length > 0) {
                thumbnails.forEach(thumb => {
                    thumb.addEventListener('click', function() {
                        const imagePath = this.getAttribute('data-image');
                        const mainImage = document.getElementById('main-product-img');
                        mainImage.src = imagePath;
                        
                        // Update active class
                        thumbnails.forEach(t => t.classList.remove('active'));
                        this.classList.add('active');
                    });
                });
            }
            
            // Buy Now Form Submission
            document.getElementById('buyNowForm').addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Get form data
                const formData = new FormData(this);
                const productName = formData.get('product_name');
                const productPrice = formData.get('product_price');
                const quantity = formData.get('quantity');
                const name = formData.get('name');
                const phone = formData.get('phone');
                const email = formData.get('email');
                const address = formData.get('address');
                const city = formData.get('city');
                const state = formData.get('state');
                const pincode = formData.get('pincode');
                const country = formData.get('country');
                const landmark = formData.get('landmark');
                
                // Calculate total
                const total = (parseFloat(productPrice) * parseInt(quantity)).toFixed(2);
                
                // Create WhatsApp message
                const message = `*New Order Inquiry*%0A%0A` +
                               `*Product:* ${productName}%0A` +
                               `*Quantity:* ${quantity}%0A` +
                               `*Price per unit:* ₹${productPrice}%0A` +
                               `*Total Amount:* ₹${total}%0A%0A` +
                               `*Customer Details:*%0A` +
                               `Name: ${name}%0A` +
                               `Phone: ${phone}%0A` +
                               `Email: ${email}%0A%0A` +
                               `*Shipping Address:*%0A` +
                               `${address}%0A` +
                               `${city}, ${state}%0A` +
                               `${pincode}%0A` +
                               `${country}%0A` +
                               `Landmark: ${landmark || 'N/A'}`;
                
                // Open WhatsApp with pre-filled message
                window.open(`https://wa.me/919277312269?text=${message}`, '_blank');
                
                // Close the modal
                const modal = bootstrap.Modal.getInstance(document.getElementById('buyNowModal'));
                modal.hide();
            });
        });
    </script>

    <!-- AOS Animation -->
    <script>
        AOS.init({
            duration: 1600,
        });
        AOS.init();
    </script>
</body>
</html>