<?php include 'connect.php' ?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shop - Barbell Life – Unisex Gym</title>
    <!-- CSS Here -->
    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/x-icon">
    <link href="https://fonts.googleapis.com/css2?family=Zen+Dots&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/all.min.css">
    <link rel="stylesheet" href="assets/css/slick.css">
    <link rel="stylesheet" href="assets/css/animate_plugin.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/aos.css">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/media-query.css">
    <style>
        /* Shop Page Specific Styles */
        .shop-page {
            padding: 80px 0;
        }

        .product-card {
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            margin-bottom: 30px;
            background: #fff;
            height: 100%;
            font-family: "Merriweather", Georgia, serif !important;

        }

        .product-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 25px rgba(0, 0, 0, 0.15);
        }

        .product-image {
            position: relative;
            overflow: hidden;
            height: 250px;
        }

        .product-image img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            transition: transform 0.5s ease;
        }

        .product-card:hover .product-image img {
            transform: scale(1.05);
        }

        .product-hover-actions {
            position: absolute;
            bottom: -60px;
            left: 0;
            right: 0;
            background: rgba(255, 255, 255, 0.9);
            display: flex;
            justify-content: center;
            padding: 15px 0;
            transition: all 0.3s ease;
        }

        .product-card:hover .product-hover-actions {
            bottom: 0;
        }

        .action-btn {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #ff6b00;
            color: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 8px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .action-btn:hover {
            background: #e55d00;
            transform: scale(1.1);
        }

        .product-info {
            padding: 20px;
        }

        .product-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 10px;
            color: #222;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
            /* height: 52px; */
        }

        .product-price {
            color: #ff6b00;
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 5px;
        }

        .product-stock {
            font-size: 14px;
            color: #28a745;
            margin-bottom: 15px;
        }

        .product-weight {
            font-size: 14px;
            color: #777;
        }

        .pagination-container {
            margin-top: 50px;
        }

        .page-item.active .page-link {
            background-color: #ff6b00;
            border-color: #ff6b00;
        }

        .page-link {
            color: #ff6b00;
        }

        .page-link:hover {
            color: #e55d00;
        }

        .shop-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            flex-wrap: wrap;
        }

        .products-count {
            font-size: 16px;
            color: #666;
        }

        /* Responsive adjustments */
        @media (max-width: 992px) {
            .product-card {
                margin-bottom: 20px;
            }
        }

        @media (max-width: 768px) {
            .shop-header {
                flex-direction: column;
                align-items: flex-start;
            }

            .products-count {
                margin-top: 10px;
            }

            .product-image {
                height: 200px;
            }
        }

        @media (max-width: 576px) {
            .col-md-3 {
                flex: 0 0 50%;
                max-width: 50%;
            }

            .product-title {
                font-size: 16px;
                height: 48px;
            }

            .product-price {
                font-size: 18px;
            }
        }
    </style>
</head>

<body>
    <!-- Preloader Start -->
    <!-- <div class="preloader">
        <div class="preloader-content">
            <div class="preloader_img_circle"></div>
            <div class="preloader_img">
                <img src="assets/images/preloader/fitness_preimg.gif" alt="fitness_preimg">
            </div>
        </div>
    </div> -->
    <!-- Preloader end -->

    <div class="site_content">
        <!-- Header Start -->
        <?php include 'assets/config/header.php' ?>
        <!-- Header end -->

        <!-- Common Page Banner Start -->
        <section class="commom_banner_sec" id="commom_banner_sec">
            <div class="common_banner_bg">
                <div class="container">
                    <div class="common_banner_content text-lg-start text-center">
                        <h1 class="d-none">hidden</h1>
                        <h2 class="d-none">hidden</h2>
                        <h3 class="d-none">hidden</h3>
                        <h4 class="d-none">hidden</h4>
                        <h5 class="satoshi_fontfamily line_height_normal fw_500 color_white" data-aos="fade-down">
                            <a href="index" class="color_white">Home</a> / <span class="color_orange">Shop</span>
                        </h5>
                        <h2 class="color_white line_height_normal pt-20" data-aos="fade-down">Shop</h2>
                        <h3 class="d-none">hidden</h3>
                        <h4 class="d-none">hidden</h4>
                    </div>
                </div>
            </div>
        </section>
        <!-- Common Page Banner end -->

        <!-- Shop Section Start -->
        <section class="shop-page">
            <div class="container">
                <div class="shop-header">
                    <h3>Our Products</h3>
                    <div class="products-count">
                        <?php
                        // Database connection
                        
                        // Get total number of products
                        $sql = "SELECT COUNT(*) as total FROM products WHERE status = 'active'";
                        $result = $conn->query($sql);
                        $total_products = $result->fetch_assoc()['total'];

                        // Calculate total pages (24 products per page)
                        $products_per_page = 24;
                        $total_pages = ceil($total_products / $products_per_page);

                        // Get current page
                        $current_page = isset($_GET['page']) ? $_GET['page'] : 1;
                        $offset = ($current_page - 1) * $products_per_page;

                        echo "Showing " . (($current_page - 1) * $products_per_page + 1) . " - " .
                            min($current_page * $products_per_page, $total_products) . " of $total_products products";
                        ?>
                    </div>
                </div>

                <div class="row">
                    <?php
                    // Fetch products with their primary images
                    $sql = "SELECT p.*, pi.image_path 
                            FROM products p 
                            LEFT JOIN product_images pi ON p.id = pi.product_id AND pi.is_primary = 1 
                            WHERE p.status = 'active' 
                            ORDER BY p.created_at DESC 
                            LIMIT $offset, $products_per_page";

                    $result = $conn->query($sql);

                  if ($result->num_rows > 0) {
 while ($row = $result->fetch_assoc()) {
    echo '
    <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
        <div class="product-card" data-aos="fade-up">
            <div class="product-image">
                <img src="admin/' . htmlspecialchars($row['image_path'], ENT_QUOTES, 'UTF-8') . '" 
                     alt="' . htmlspecialchars($row['name'], ENT_QUOTES, 'UTF-8') . '">

                <div class="product-hover-actions">
                    <div class="action-btn" title="Add to Cart">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                    <a href="product-details.php?product=' . urlencode($row['name']) . '" class="action-btn" title="View Details">
                        <i class="fas fa-eye"></i>
                    </a>
                </div>
            </div>

            <div class="product-info">
                <h3 class="product-title">' . htmlspecialchars($row['name'], ENT_QUOTES, 'UTF-8') . '</h3>
                <div class="product-price">₹' . number_format($row['price'], 2) . '</div>
                <div class="product-stock">In Stock: ' . (int)$row['stock_quantity'] . '</div>
                <div class="product-weight">Weight: ' . htmlspecialchars($row['weight_value']) . ' ' . htmlspecialchars($row['weight_unit']) . '</div>
            </div>
        </div>
    </div>';
}

}
else {
                        echo '<div class="col-12 text-center"><p>No products found.</p></div>';
                    }
                    ?>
                </div>

                <!-- Pagination -->
                <?php if ($total_pages > 1): ?>
                    <div class="pagination-container">
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?php if ($current_page > 1): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?php echo $current_page - 1; ?>"
                                            aria-label="Previous">
                                            <span aria-hidden="true">&laquo;</span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php
                                // Show page numbers
                                $start_page = max(1, $current_page - 2);
                                $end_page = min($total_pages, $start_page + 4);

                                // Adjust if we're near the end
                                if ($end_page - $start_page < 4) {
                                    $start_page = max(1, $end_page - 4);
                                }

                                for ($i = $start_page; $i <= $end_page; $i++):
                                    ?>
                                    <li class="page-item <?php echo ($i == $current_page) ? 'active' : ''; ?>">
                                        <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                                    </li>
                                <?php endfor; ?>

                                <?php if ($current_page < $total_pages): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?php echo $current_page + 1; ?>" aria-label="Next">
                                            <span aria-hidden="true">&raquo;</span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                    </div>
                <?php endif; ?>
            </div>
        </section>
        <!-- Shop Section End -->

        <!-- Gym-Marqueer-Text Start -->
        <?php include 'assets/config/slider.php'; ?>
        <!-- Gym-Marqueer-Text End -->

        <!-- footer Start -->
        <?php include 'assets/config/footer.php'; ?>
        <!-- footer End -->

        <!-- Scroll-Top Start -->
        <div class="scrolltop_area orangeglow">
            <button id="scroll-top-btn">
                <span class="scroll-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <mask style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="24" height="24">
                            <path d="M0 0H24V24H0V0Z" fill="white" />
                        </mask>
                        <g>
                            <path d="M7 11L12 6L17 11" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path d="M7 17L12 12L17 17" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                        </g>
                    </svg>
                </span>
                <span id="scroll-percentage"></span>
            </button>
        </div>
        <!-- Scroll-Top End -->

        <!-- custome mouse -->
        <div class="megic-cursor">
            <div class="megic-cursor-item"></div>
        </div>
    </div>

    <!-- JS Here -->
    <script src="assets/js/jquery-3.7.1.js"></script>
    <script src="assets/js/myplugin.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/slick-animation.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script src="assets/js/plugins.js"></script>
    <script src="assets/js/TweenMax.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/allsliders.js"></script>
    <script src="assets/js/custome-cursor.js"></script>
    <script src="assets/js/style.js"></script>

    <!-- AOS Animation -->
    <script>
        AOS.init({
            duration: 1600,
        });
        AOS.init();
    </script>


</body>

</html>