<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Best Gym Packages - Barbell Life – Unisex Gym</title>
    <!-- CSS Here -->
    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/x-icon">
    <link href="https://fonts.googleapis.com/css2?family=Zen+Dots&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/all.min.css">
    <link rel="stylesheet" href="assets/css/slick.css">
    <link rel="stylesheet" href="assets/css/animate_plugin.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/aos.css">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/media-query.css">
    <style>
        .container {
            max-width: 1200px;
            margin: 0 auto;
            color:#fff !important;
        }
        
        .header {
            text-align: center;
            margin-bottom: 40px;
            padding: 20px;
        }
        
        .title {
            font-size: 2.8rem;
            color: #ff640d;
            margin-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        
        .subtitle {
            font-size: 1.2rem;
            color: #ccc;
            max-width: 800px;
            margin: 0 auto;
        }
        
        .workout-plan {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 25px;
            margin-bottom: 50px;
        }
        
        .day-card {
            background: linear-gradient(145deg, #1a1a1a, #252525);
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.4);
            transition: transform 0.3s ease;
        }
        
        .day-card:hover {
            transform: translateY(-5px);
        }
        
        .day-header {
            background: #ff640d;
            padding: 20px;
            text-align: center;
        }
        
        .day-title {
            font-size: 1.6rem;
            margin: 0;
            color: white;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .day-content {
            padding: 25px;
        }
        
        .muscle-group {
            margin-bottom: 25px;
        }
        
        .muscle-title {
            color: #ff640d;
            font-size: 1.3rem;
            margin-bottom: 15px;
            padding-bottom: 5px;
            border-bottom: 1px solid #444;
            display: flex;
            align-items: center;
        }
        
        .muscle-title i {
            margin-right: 10px;
        }
        
        .exercise-list {
            list-style-type: none;
        }
        
        .exercise-item {
            padding: 12px 15px;
            margin-bottom: 10px;
            background: #2a2a2a;
            border-radius: 8px;
            display: flex;
            align-items: center;
            border-left: 4px solid #ff640d;
        }
        
        .exercise-item i {
            color: #ff640d;
            margin-right: 12px;
            font-size: 0.9rem;
        }
        
        .sub-exercises {
            list-style-type: none;
            margin-top: 10px;
            margin-left: 20px;
        }
        
        .sub-exercise-item {
            padding: 8px 15px;
            margin-bottom: 8px;
            background: #242424;
            border-radius: 6px;
            display: flex;
            align-items: center;
            border-left: 3px solid #ff9535;
        }
        
        .note-box {
            background: rgba(255, 100, 13, 0.1);
            border-left: 4px solid #ff640d;
            padding: 20px;
            border-radius: 0 8px 8px 0;
            margin-top: 30px;
            color:#000;
        }
        
        .note-title {
            color: #ff640d;
            font-weight: 600;
            margin-bottom: 10px;
            font-size: 1.2rem;
        }
        
        @media (max-width: 768px) {
            .workout-plan {
                grid-template-columns: 1fr;
            }
            
            .title {
                font-size: 2.2rem;
            }
        }
        
        @media (max-width: 480px) {
            .title {
                font-size: 1.8rem;
            }
            
            .day-header {
                padding: 15px;
            }
            
            .day-title {
                font-size: 1.4rem;
            }
            
            .day-content {
                padding: 20px;
            }
        }
    </style>
</head>

<body>
    <!-- Preloader Start -->
    <div class="preloader">
        <div class="preloader-content">
            <div class="preloader_img_circle"></div>
            <div class="preloader_img">
                <img src="assets/images/preloader/fitness_preimg.gif" alt="fitness_preimg">
            </div>
        </div>
    </div>
    <!-- Preloader end -->

    <div class="site_content">
        <!-- Header Start -->
        <?php include 'assets/config/header.php' ?>
        <!-- Header end -->

        <!-- Common Page Banner Start -->
        <section class="commom_banner_sec" id="commom_banner_sec">
            <div class="common_banner_bg common_banner_ourpricingplanpage_bg">
                <div class="container">
                    <div class="common_banner_content text-lg-start text-center">
                        <h1 class="d-none">hidden</h1>
                        <h2 class="d-none">hidden</h2>
                        <h3 class="d-none">hidden</h3>
                        <h4 class="d-none">hidden</h4>
                        <h5 class="satoshi_fontfamily line_height_normal fw_500 color_white" data-aos="fade-down">
                            <a href="index" class="color_white">Home</a> / <span class="color_orange">Weekly Workout Plan 
                                </span>
                        </h5>
                        <h2 class="color_white line_height_normal pt-20" data-aos="fade-down">Weekly Workout Plan</h2>
                        <h3 class="d-none">hidden</h3>
                        <h4 class="d-none">hidden</h4>
                    </div>
                </div>
            </div>
        </section>
        <!-- Common Page Banner end -->

       
        <!-- Pricing-Plans End -->
 <section class="diet-section" id="weightLossDiet">
        <div class="container">
        <div class="header">
            <h1 class="title">Weekly Workout Plan</h1>
            <p class="subtitle">Professional training schedule designed by Barbell Life Fitness Unisex Gym experts</p>
        </div>
        
        <div class="workout-plan">
            <!-- Monday -->
            <div class="day-card">
                <div class="day-header">
                    <h3 class="day-title">Monday - Back / Biceps</h3>
                </div>
                <div class="day-content">
                    <div class="muscle-group">
                        <h4 class="muscle-title"><i class="fas fa-dumbbell"></i> Back Exercises</h4>
                        <ul class="exercise-list">
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Lat pull front back</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Deadlift</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Single Arm Rowing</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Hyper Extension</li>
                        </ul>
                    </div>
                    
                    <div class="muscle-group">
                        <h4 class="muscle-title"><i class="fas fa-dumbbell"></i> Bicep Exercises</h4>
                        <ul class="exercise-list">
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> B-Curl</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Dumble Curl</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Hammer Curl</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Spider Curl</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Concentration</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Tuesday -->
            <div class="day-card">
                <div class="day-header">
                    <h3 class="day-title">Tuesday - Shoulders / Thighs</h3>
                </div>
                <div class="day-content">
                    <div class="muscle-group">
                        <h4 class="muscle-title"><i class="fas fa-dumbbell"></i> Shoulder Exercises</h4>
                        <ul class="exercise-list">
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Military press front</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Dumble press</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Arnold press</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Lateral Raise</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Shrugs</li>
                        </ul>
                    </div>
                    
                    <div class="muscle-group">
                        <h4 class="muscle-title"><i class="fas fa-dumbbell"></i> Leg Exercises</h4>
                        <ul class="exercise-list">
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Squats</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Extension</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Curl</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Press</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Lunges</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Wednesday -->
            <div class="day-card">
                <div class="day-header">
                    <h3 class="day-title">Wednesday - Chest / Triceps</h3>
                </div>
                <div class="day-content">
                    <div class="muscle-group">
                        <h4 class="muscle-title"><i class="fas fa-dumbbell"></i> Chest Exercises</h4>
                        <ul class="exercise-list">
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Flat Bench</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Incline Bench</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Decline Bench</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Cable fly</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Pull over</li>
                        </ul>
                    </div>
                    
                    <div class="muscle-group">
                        <h4 class="muscle-title"><i class="fas fa-dumbbell"></i> Tricep Exercises</h4>
                        <ul class="exercise-list">
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Skull Crusher</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Single Arm</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Both Arm</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Press Down</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Rope Pull Down</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Thursday -->
            <div class="day-card">
                <div class="day-header">
                    <h3 class="day-title">Thursday - Back / Biceps</h3>
                </div>
                <div class="day-content">
                    <div class="muscle-group">
                        <h4 class="muscle-title"><i class="fas fa-dumbbell"></i> Back Exercises</h4>
                        <ul class="exercise-list">
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Bend over Rowing</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Cable Raise Lats</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Seated Rowing</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Back Butterfly</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Hyper Extension</li>
                        </ul>
                    </div>
                    
                    <div class="muscle-group">
                        <h4 class="muscle-title"><i class="fas fa-dumbbell"></i> Bicep Exercises</h4>
                        <ul class="exercise-list">
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Cable Curl</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Cable Concentration</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Preacher Bench Table with Rod</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Barbell Curl</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Incline Dumble Curl</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Friday -->
            <div class="day-card">
                <div class="day-header">
                    <h3 class="day-title">Friday - Shoulder / Legs</h3>
                </div>
                <div class="day-content">
                    <div class="muscle-group">
                        <h4 class="muscle-title"><i class="fas fa-dumbbell"></i> Shoulder Exercises</h4>
                        <ul class="exercise-list">
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Military press Back</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Front Raise</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Face pull</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Up Ride Row</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Barbell Shrugs</li>
                        </ul>
                    </div>
                    
                    <div class="muscle-group">
                        <h4 class="muscle-title"><i class="fas fa-dumbbell"></i> Leg Exercises</h4>
                        <ul class="exercise-list">
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Sumo Squats</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Hamstring</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Walking Lunges</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Calf Raise</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Smith Hack Squats</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Saturday -->
            <div class="day-card">
                <div class="day-header">
                    <h3 class="day-title">Saturday - Chest / Triceps</h3>
                </div>
                <div class="day-content">
                    <div class="muscle-group">
                        <h4 class="muscle-title"><i class="fas fa-dumbbell"></i> Chest Exercises</h4>
                        <ul class="exercise-list">
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Flat / Incline / Decline Dumble</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Butterfly</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Incline Close Dumble Press</li>
                        </ul>
                    </div>
                    
                    <div class="muscle-group">
                        <h4 class="muscle-title"><i class="fas fa-dumbbell"></i> Tricep Exercises</h4>
                        <ul class="exercise-list">
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Over Head Cable</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Reverse Press Down</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Kick Back</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Back Dips</li>
                            <li class="exercise-item"><i class="fas fa-check-circle"></i> Tricep Dips</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="note-box">
            <h4 class="note-title">Training Notes:</h4>
            <p>• Always warm up for 10-15 minutes before starting your workout</p>
            <p>• Maintain proper form to prevent injuries</p>
            <p>• Rest for 60-90 seconds between sets</p>
            <p>• Stay hydrated throughout your workout</p>
            <p>• Include stretching and cool down after each session</p>
            <p>• Sunday is rest day for recovery</p>
        </div>
    </div>
    </section>
       

        <!-- Get-Touch Start -->
      
        <!-- Get-Touch End -->



        <!-- Gym-Marqueer-Text Start -->
        <?php include 'assets/config/slider.php'; ?>
        <!-- Gym-Marqueer-Text End -->

        <!-- footer Start -->
        <?php include 'assets/config/footer.php'; ?>
        <!-- footer End -->

        <!-- Scroll-Top Start -->
        <div class="scrolltop_area orangeglow">
            <button id="scroll-top-btn">
                <span class="scroll-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <mask style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="24" height="24">
                            <path d="M0 0H24V24H0V0Z" fill="white" />
                        </mask>
                        <g>
                            <path d="M7 11L12 6L17 11" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path d="M7 17L12 12L17 17" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                        </g>
                    </svg>
                </span>
                <span id="scroll-percentage"></span>
            </button>
        </div>
        <!-- Scroll-Top End -->

        <!-- custome mouse -->
        <div class="megic-cursor">
            <div class="megic-cursor-item"></div>
        </div>
    </div>

    <!-- JS Here -->
    <script src="assets/js/jquery-3.7.1.js"></script>
    <script src="assets/js/myplugin.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/slick-animation.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script src="assets/js/plugins.js"></script>
    <script src="assets/js/TweenMax.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/allsliders.js"></script>
    <script src="assets/js/custome-cursor.js"></script>
    <script src="assets/js/style.js"></script>

    <!-- AOS Animation -->
    <script>
        AOS.init({
            duration: 1600,
        });
        AOS.init();
    </script>
</body>


</html>